<?php
// auto-generated by sfCompileConfigHandler
// date: 2022/02/01 04:36:28

class sfAutoload
{
  static protected
    $freshCache = false,
    $instance   = null;
  protected
    $overriden = array(),
    $classes   = array();
  protected function __construct()
  {
  }
  static public function getInstance()
  {
    if (!isset(self::$instance))
    {
      self::$instance = new sfAutoload();
    }
    return self::$instance;
  }
  static public function register()
  {
    ini_set('unserialize_callback_func', 'spl_autoload_call');
    if (false === spl_autoload_register(array(self::getInstance(), 'autoload')))
    {
      throw new sfException(sprintf('Unable to register %s::autoload as an autoloading method.', get_class(self::getInstance())));
    }
  }
  static public function unregister()
  {
    spl_autoload_unregister(array(self::getInstance(), 'autoload'));
  }
  public function setClassPath($class, $path)
  {
    $class = strtolower($class);
    $this->overriden[$class] = $path;
    $this->classes[$class] = $path;
  }
  public function getClassPath($class)
  {
    $class = strtolower($class);
    return isset($this->classes[$class]) ? $this->classes[$class] : null;
  }
  public function reloadClasses($force = false)
  {
        if (self::$freshCache && !$force)
    {
      return false;
    }
    $configuration = sfProjectConfiguration::getActive();
    if (!$configuration || !$configuration instanceof sfApplicationConfiguration)
    {
      return false;
    }
    self::$freshCache = true;
    if (is_file($configuration->getConfigCache()->getCacheName('config/autoload.yml')))
    {
      self::$freshCache = false;
      if ($force)
      {
        if (file_exists($configuration->getConfigCache()->getCacheName('config/autoload.yml')))
        {
          unlink($configuration->getConfigCache()->getCacheName('config/autoload.yml'));
        }
      }
    }
    $file = $configuration->getConfigCache()->checkConfig('config/autoload.yml');
    if ($force && defined('HHVM_VERSION'))
    {
            $this->classes = eval(str_replace('<?php', '', file_get_contents($file)));
    }
    else
    {
      $this->classes = include $file;
    }
    foreach ($this->overriden as $class => $path)
    {
      $this->classes[$class] = $path;
    }
    return true;
  }
  public function autoload($class)
  {
        if (!$this->classes)
    {
      self::reloadClasses();
    }
    return self::loadClass($class);
  }
  public function loadClass($class)
  {
    $class = strtolower($class);
        if (class_exists($class, false) || interface_exists($class, false) || (function_exists('trait_exists') && trait_exists($class, false)))
    {
      return true;
    }
        if (isset($this->classes[$class]))
    {
      try
      {
        require $this->classes[$class];
      }
      catch (sfException $e)
      {
        $e->printStackTrace();
      }
      catch (Exception $e)
      {
        sfException::createFromException($e)->printStackTrace();
      }
      return true;
    }
        if (
      sfContext::hasInstance()
      &&
      ($module = sfContext::getInstance()->getModuleName())
      &&
      isset($this->classes[$module.'/'.$class])
    )
    {
      try
      {
        require $this->classes[$module.'/'.$class];
      }
      catch (sfException $e)
      {
        $e->printStackTrace();
      }
      catch (Exception $e)
      {
        sfException::createFromException($e)->printStackTrace();
      }
      return true;
    }
    return false;
  }
}

abstract class sfComponent
{
  protected $moduleName             = '';
  protected $actionName             = '';
  protected $context                = null;
  protected $dispatcher             = null;
  protected $request                = null;
  protected $response               = null;
  protected $varHolder              = null;
  protected $requestParameterHolder = null;
  public function __construct($context, $moduleName, $actionName)
  {
    $this->initialize($context, $moduleName, $actionName);
  }
  public function initialize($context, $moduleName, $actionName)
  {
    $this->moduleName             = $moduleName;
    $this->actionName             = $actionName;
    $this->context                = $context;
    $this->dispatcher             = $context->getEventDispatcher();
    $this->varHolder              = new sfParameterHolder();
    $this->request                = $context->getRequest();
    $this->response               = $context->getResponse();
    $this->requestParameterHolder = $this->request->getParameterHolder();
  }
  abstract function execute($request);
  public function getModuleName()
  {
    return $this->moduleName;
  }
  public function getActionName()
  {
    return $this->actionName;
  }
  public final function getContext()
  {
    return $this->context;
  }
  public final function getServiceContainer()
  {
    return $this->context->getServiceContainer();
  }
  public function getService($id)
  {
    return $this->getServiceContainer()->getService($id);
  }
  public final function getLogger()
  {
    return $this->context->getLogger();
  }
  public function logMessage($message, $priority = 'info')
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array($message, 'priority' => constant('sfLogger::'.strtoupper($priority)))));
    }
  }
  public function __($string, $args = array(), $catalogue = 'messages')
  {
    return $this->context->getI18N()->__($string, $args, $catalogue);
  }
  public function getRequestParameter($name, $default = null)
  {
    return $this->requestParameterHolder->get($name, $default);
  }
  public function hasRequestParameter($name)
  {
    return $this->requestParameterHolder->has($name);
  }
  public function getRequest()
  {
    return $this->request;
  }
  public function getResponse()
  {
    return $this->response;
  }
  public function getController()
  {
    return $this->context->getController();
  }
  public function generateUrl($route, $params = array(), $absolute = false)
  {
    return $this->context->getRouting()->generate($route, $params, $absolute);
  }
  public function getUser()
  {
    return $this->context->getUser();
  }
  public function getMailer()
  {
    return $this->getContext()->getMailer();
  }
  public function setVar($name, $value, $safe = false)
  {
    $this->varHolder->set($name, $safe ? new sfOutputEscaperSafe($value) : $value);
  }
  public function getVar($name)
  {
    return $this->varHolder->get($name);
  }
  public function getVarHolder()
  {
    return $this->varHolder;
  }
  public function __set($key, $value)
  {
    return $this->varHolder->setByRef($key, $value);
  }
  public function & __get($key)
  {
    return $this->varHolder->get($key);
  }
  public function __isset($name)
  {
    return $this->varHolder->has($name);
  }
  public function __unset($name)
  {
    $this->varHolder->remove($name);
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'component.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
}

abstract class sfAction extends sfComponent
{
  protected
    $security = array();
  public function initialize($context, $moduleName, $actionName)
  {
    parent::initialize($context, $moduleName, $actionName);
        if ($file = $context->getConfigCache()->checkConfig('modules/'.$this->getModuleName().'/config/security.yml', true))
    {
      require($file);
    }
  }
  public function preExecute()
  {
  }
  public function postExecute()
  {
  }
  public function forward404($message = null)
  {
    throw new sfError404Exception($this->get404Message($message));
  }
  public function forward404Unless($condition, $message = null)
  {
    if (!$condition)
    {
      throw new sfError404Exception($this->get404Message($message));
    }
  }
  public function forward404If($condition, $message = null)
  {
    if ($condition)
    {
      throw new sfError404Exception($this->get404Message($message));
    }
  }
  public function redirect404()
  {
    return $this->redirect('/'.sfConfig::get('sf_error_404_module').'/'.sfConfig::get('sf_error_404_action'));
  }
  public function forward($module, $action)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Forward to action "%s/%s"', $module, $action))));
    }
    $this->getController()->forward($module, $action);
    throw new sfStopException();
  }
  public function forwardIf($condition, $module, $action)
  {
    if ($condition)
    {
      $this->forward($module, $action);
    }
  }
  public function forwardUnless($condition, $module, $action)
  {
    if (!$condition)
    {
      $this->forward($module, $action);
    }
  }
  public function redirect($url, $statusCode = 302)
  {
        if (is_object($statusCode) || is_array($statusCode))
    {
      $url = array_merge(array('sf_route' => $url), is_object($statusCode) ? array('sf_subject' => $statusCode) : $statusCode);
      $statusCode = func_num_args() >= 3 ? func_get_arg(2) : 302;
    }
    $this->getController()->redirect($url, 0, $statusCode);
    throw new sfStopException();
  }
  public function redirectIf($condition, $url, $statusCode = 302)
  {
    if ($condition)
    {
            $arguments = func_get_args();
      call_user_func_array(array($this, 'redirect'), array_slice($arguments, 1));
    }
  }
  public function redirectUnless($condition, $url, $statusCode = 302)
  {
    if (!$condition)
    {
            $arguments = func_get_args();
      call_user_func_array(array($this, 'redirect'), array_slice($arguments, 1));
    }
  }
  public function renderText($text)
  {
    $this->getResponse()->setContent($this->getResponse()->getContent().$text);
    return sfView::NONE;
  }
  public function renderJson($data)
  {
    $this->getResponse()->setContentType('application/json');
    $this->getResponse()->setContent(json_encode($data));
    return sfView::NONE;
  }
  public function getPartial($templateName, $vars = null)
  {
    $this->getContext()->getConfiguration()->loadHelpers('Partial');
    $vars = null !== $vars ? $vars : $this->varHolder->getAll();
    return get_partial($templateName, $vars);
  }
  public function renderPartial($templateName, $vars = null)
  {
    return $this->renderText($this->getPartial($templateName, $vars));
  }
  public function getComponent($moduleName, $componentName, $vars = null)
  {
    $this->getContext()->getConfiguration()->loadHelpers('Partial');
    $vars = null !== $vars ? $vars : $this->varHolder->getAll();
    return get_component($moduleName, $componentName, $vars);
  }
  public function renderComponent($moduleName, $componentName, $vars = null)
  {
    return $this->renderText($this->getComponent($moduleName, $componentName, $vars));
  }
  public function getSecurityConfiguration()
  {
    return $this->security;
  }
  public function setSecurityConfiguration($security)
  {
    $this->security = $security;
  }
  public function getSecurityValue($name, $default = null)
  {
    $actionName = strtolower($this->getActionName());
    if (isset($this->security[$actionName][$name]))
    {
      return $this->security[$actionName][$name];
    }
    if (isset($this->security['all'][$name]))
    {
      return $this->security['all'][$name];
    }
    return $default;
  }
  public function isSecure()
  {
    return $this->getSecurityValue('is_secure', false);
  }
  public function getCredential()
  {
    return $this->getSecurityValue('credentials');
  }
  public function setTemplate($name, $module = null)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Change template to "%s/%s"', null === $module ? 'CURRENT' : $module, $name))));
    }
    if (null !== $module)
    {
      $dir = $this->context->getConfiguration()->getTemplateDir($module, $name.sfView::SUCCESS.'.php');
      $name = $dir.'/'.$name;
    }
    sfConfig::set('symfony.view.'.$this->getModuleName().'_'.$this->getActionName().'_template', $name);
  }
  public function getTemplate()
  {
    return sfConfig::get('symfony.view.'.$this->getModuleName().'_'.$this->getActionName().'_template');
  }
  public function setLayout($name)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Change layout to "%s"', $name))));
    }
    sfConfig::set('symfony.view.'.$this->getModuleName().'_'.$this->getActionName().'_layout', $name);
  }
  public function getLayout()
  {
    return sfConfig::get('symfony.view.'.$this->getModuleName().'_'.$this->getActionName().'_layout');
  }
  public function setViewClass($class)
  {
    sfConfig::set('mod_'.strtolower($this->getModuleName()).'_view_class', $class);
  }
  public function getRoute()
  {
    return $this->getRequest()->getAttribute('sf_route');
  }
  protected function get404Message($message = null)
  {
    return null === $message ? sprintf('This request has been forwarded to a 404 error page by the action "%s/%s".', $this->getModuleName(), $this->getActionName()) : $message;
  }
}

abstract class sfActions extends sfAction
{
  public function execute($request)
  {
        $actionToRun = 'execute'.ucfirst($this->getActionName());
    if ($actionToRun === 'execute')
    {
            throw new sfInitializationException(sprintf('sfAction initialization failed for module "%s". There was no action given.', $this->getModuleName()));
    }
    if (!is_callable(array($this, $actionToRun)))
    {
            throw new sfInitializationException(sprintf('sfAction initialization failed for module "%s", action "%s". You must create a "%s" method.', $this->getModuleName(), $this->getActionName(), $actionToRun));
    }
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Call "%s->%s()"', get_class($this), $actionToRun))));
    }
        return $this->$actionToRun($request);
  }
}

class sfActionStack
{
  protected
    $stack = array();
  public function addEntry($moduleName, $actionName, $actionInstance)
  {
        $actionEntry = new sfActionStackEntry($moduleName, $actionName, $actionInstance);
    $this->stack[] = $actionEntry;
    return $actionEntry;
  }
  public function getEntry($index)
  {
    $retval = null;
    if ($index > -1 && $index < count($this->stack))
    {
      $retval = $this->stack[$index];
    }
    return $retval;
  }
  public function popEntry()
  {
    return array_pop($this->stack);
  }
  public function getFirstEntry()
  {
    $retval = null;
    if (isset($this->stack[0]))
    {
      $retval = $this->stack[0];
    }
    return $retval;
  }
  public function getLastEntry()
  {
    $count  = count($this->stack);
    $retval = null;
    if (isset($this->stack[0]))
    {
      $retval = $this->stack[$count - 1];
    }
    return $retval;
  }
  public function getSize()
  {
    return count($this->stack);
  }
}

class sfActionStackEntry
{
  protected
    $actionInstance = null,
    $actionName     = null,
    $moduleName     = null,
    $presentation   = null;
  public function __construct($moduleName, $actionName, $actionInstance)
  {
    $this->actionName     = $actionName;
    $this->actionInstance = $actionInstance;
    $this->moduleName     = $moduleName;
  }
  public function getActionName()
  {
    return $this->actionName;
  }
  public function getActionInstance()
  {
    return $this->actionInstance;
  }
  public function getModuleName()
  {
    return $this->moduleName;
  }
  public function & getPresentation()
  {
    return $this->presentation;
  }
  public function setPresentation(&$presentation)
  {
    $this->presentation =& $presentation;
  }
}

abstract class sfController
{
  protected $context = null;
  protected $dispatcher = null;
  protected $controllerClasses = array();
  protected $renderMode = sfView::RENDER_CLIENT;
  protected $maxForwards = 5;
  public function __construct($context)
  {
    $this->initialize($context);
  }
  public function initialize($context)
  {
    $this->context    = $context;
    $this->dispatcher = $context->getEventDispatcher();
  }
  public function componentExists($moduleName, $componentName)
  {
    return $this->controllerExists($moduleName, $componentName, 'component', false);
  }
  public function actionExists($moduleName, $actionName)
  {
    return $this->controllerExists($moduleName, $actionName, 'action', false);
  }
  protected function controllerExists($moduleName, $controllerName, $extension, $throwExceptions)
  {
    $dirs = $this->context->getConfiguration()->getControllerDirs($moduleName);
    foreach ($dirs as $dir => $checkEnabled)
    {
            if ($checkEnabled && !in_array($moduleName, sfConfig::get('sf_enabled_modules')) && is_readable($dir))
      {
        throw new sfConfigurationException(sprintf('The module "%s" is not enabled.', $moduleName));
      }
            $this->context->getConfigCache()->import('modules/'.$moduleName.'/config/generator.yml', false, true);
            $classFile   = strtolower($extension);
      $classSuffix = ucfirst(strtolower($extension));
      $file        = $dir.'/'.$controllerName.$classSuffix.'.class.php';
      if (is_readable($file))
      {
                require_once($file);
        $this->controllerClasses[$moduleName.'_'.$controllerName.'_'.$classSuffix] = $controllerName.$classSuffix;
        return true;
      }
      $module_file = $dir.'/'.$classFile.'s.class.php';
      if (is_readable($module_file))
      {
                require_once($module_file);
        if (!class_exists($moduleName.$classSuffix.'s', false))
        {
          if ($throwExceptions)
          {
            throw new sfControllerException(sprintf('There is no "%s" class in your action file "%s".', $moduleName.$classSuffix.'s', $module_file));
          }
          return false;
        }
                if (!in_array('execute'.ucfirst($controllerName), get_class_methods($moduleName.$classSuffix.'s')))
        {
          if ($throwExceptions)
          {
            throw new sfControllerException(sprintf('There is no "%s" method in your action class "%s".', 'execute'.ucfirst($controllerName), $moduleName.$classSuffix.'s'));
          }
          return false;
        }
        $this->controllerClasses[$moduleName.'_'.$controllerName.'_'.$classSuffix] = $moduleName.$classSuffix.'s';
        return true;
      }
    }
        if ($throwExceptions && sfConfig::get('sf_debug'))
    {
      $dirs = array_map(array('sfDebug', 'shortenFilePath'), array_keys($dirs));
      throw new sfControllerException(sprintf('Controller "%s/%s" does not exist in: %s.', $moduleName, $controllerName, implode(', ', $dirs)));
    }
    return false;
  }
  public function forward($moduleName, $actionName)
  {
        $moduleName = preg_replace('/[^a-z0-9_]+/i', '', $moduleName);
    $actionName = preg_replace('/[^a-z0-9_]+/i', '', $actionName);
    if ($this->getActionStack()->getSize() >= $this->maxForwards)
    {
            throw new sfForwardException('Too many forwards have been detected for this request.');
    }
        $this->context->getConfigCache()->import('modules/'.$moduleName.'/config/generator.yml', false, true);
    if (!$this->actionExists($moduleName, $actionName))
    {
            if (sfConfig::get('sf_logging_enabled'))
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Action "%s/%s" does not exist', $moduleName, $actionName))));
      }
      throw new sfError404Exception(sprintf('Action "%s/%s" does not exist.', $moduleName, $actionName));
    }
        $actionInstance = $this->getAction($moduleName, $actionName);
        $this->getActionStack()->addEntry($moduleName, $actionName, $actionInstance);
        $viewClass = sfConfig::get('mod_'.strtolower($moduleName).'_view_class', false);
    require($this->context->getConfigCache()->checkConfig('modules/'.$moduleName.'/config/module.yml'));
    if (false !== $viewClass)
    {
      sfConfig::set('mod_'.strtolower($moduleName).'_view_class', $viewClass);
    }
        if (sfConfig::get('mod_'.strtolower($moduleName).'_enabled'))
    {
            $moduleConfig = sfConfig::get('sf_app_module_dir').'/'.$moduleName.'/config/config.php';
      if (is_readable($moduleConfig))
      {
        require_once($moduleConfig);
      }
            $filterChain = new sfFilterChain();
      $filterChain->loadConfiguration($actionInstance);
      $this->context->getEventDispatcher()->notify(new sfEvent($this, 'controller.change_action', array('module' => $moduleName, 'action' => $actionName)));
      if ($moduleName == sfConfig::get('sf_error_404_module') && $actionName == sfConfig::get('sf_error_404_action'))
      {
        $this->context->getResponse()->setStatusCode(404);
        $this->context->getResponse()->setHttpHeader('Status', '404 Not Found');
        $this->dispatcher->notify(new sfEvent($this, 'controller.page_not_found', array('module' => $moduleName, 'action' => $actionName)));
      }
            $filterChain->execute();
    }
    else
    {
      $moduleName = sfConfig::get('sf_module_disabled_module');
      $actionName = sfConfig::get('sf_module_disabled_action');
      if (!$this->actionExists($moduleName, $actionName))
      {
                throw new sfConfigurationException(sprintf('Invalid configuration settings: [sf_module_disabled_module] "%s", [sf_module_disabled_action] "%s".', $moduleName, $actionName));
      }
      $this->forward($moduleName, $actionName);
    }
  }
  public function getAction($moduleName, $actionName)
  {
    return $this->getController($moduleName, $actionName, 'action');
  }
  public function getComponent($moduleName, $componentName)
  {
    return $this->getController($moduleName, $componentName, 'component');
  }
  protected function getController($moduleName, $controllerName, $extension)
  {
    $classSuffix = ucfirst(strtolower($extension));
    if (!isset($this->controllerClasses[$moduleName.'_'.$controllerName.'_'.$classSuffix]))
    {
      $this->controllerExists($moduleName, $controllerName, $extension, true);
    }
    $class = $this->controllerClasses[$moduleName.'_'.$controllerName.'_'.$classSuffix];
        $moduleClass = $moduleName.'_'.$class;
    if (class_exists($moduleClass, false))
    {
      $class = $moduleClass;
    }
    return new $class($this->context, $moduleName, $controllerName);
  }
  public function getActionStack()
  {
    return $this->context->getActionStack();
  }
  public function getRenderMode()
  {
    return $this->renderMode;
  }
  public function getView($moduleName, $actionName, $viewName)
  {
        $file = sfConfig::get('sf_app_module_dir').'/'.$moduleName.'/view/'.$actionName.$viewName.'View.class.php';
    if (is_readable($file))
    {
      require_once($file);
      $class = $actionName.$viewName.'View';
            $moduleClass = $moduleName.'_'.$class;
      if (class_exists($moduleClass, false))
      {
        $class = $moduleClass;
      }
    }
    else
    {
            $class = sfConfig::get('mod_'.strtolower($moduleName).'_view_class', 'sfPHP').'View';
    }
    return new $class($this->context, $moduleName, $actionName, $viewName);
  }
  public function getPresentationFor($module, $action, $viewName = null)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Get presentation for action "%s/%s" (view class: "%s")', $module, $action, $viewName))));
    }
        $renderMode = $this->getRenderMode();
        $this->setRenderMode(sfView::RENDER_VAR);
        $actionStack = $this->getActionStack();
        $index = $actionStack->getSize();
        if ($viewName)
    {
      $currentViewName = sfConfig::get('mod_'.strtolower($module).'_view_class');
      sfConfig::set('mod_'.strtolower($module).'_view_class', $viewName);
    }
    try
    {
            $this->forward($module, $action);
    }
    catch (Exception $e)
    {
            $this->setRenderMode($renderMode);
            if ($viewName)
      {
        sfConfig::set('mod_'.strtolower($module).'_view_class', $currentViewName);
      }
      throw $e;
    }
        $actionEntry = $actionStack->getEntry($index);
        $presentation =& $actionEntry->getPresentation();
        $this->setRenderMode($renderMode);
        $nb = $actionStack->getSize() - $index;
    while ($nb-- > 0)
    {
      $actionEntry = $actionStack->popEntry();
      if ($actionEntry->getModuleName() == sfConfig::get('sf_login_module') && $actionEntry->getActionName() == sfConfig::get('sf_login_action'))
      {
        throw new sfException('Your action is secured, but the user is not authenticated.');
      }
      else if ($actionEntry->getModuleName() == sfConfig::get('sf_secure_module') && $actionEntry->getActionName() == sfConfig::get('sf_secure_action'))
      {
        throw new sfException('Your action is secured, but the user does not have access.');
      }
    }
        if ($viewName)
    {
      sfConfig::set('mod_'.strtolower($module).'_view_class', $currentViewName);
    }
    return $presentation;
  }
  public function setRenderMode($mode)
  {
    if ($mode == sfView::RENDER_CLIENT || $mode == sfView::RENDER_VAR || $mode == sfView::RENDER_NONE)
    {
      $this->renderMode = $mode;
      return;
    }
        throw new sfRenderException(sprintf('Invalid rendering mode: %s.', $mode));
  }
  public function inCLI()
  {
    return 'cli' == PHP_SAPI;
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'controller.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
}

class sfDatabaseManager
{
  protected $configuration = null;
  protected $databases = array();
  public function __construct(sfProjectConfiguration $configuration, $options = array())
  {
    $this->initialize($configuration);
    if (!isset($options['auto_shutdown']) || $options['auto_shutdown'])
    {
      register_shutdown_function(array($this, 'shutdown'));
    }
  }
  public function initialize(sfProjectConfiguration $configuration)
  {
    $this->configuration = $configuration;
    $this->loadConfiguration();
  }
  public function loadConfiguration()
  {
    if ($this->configuration instanceof sfApplicationConfiguration)
    {
      $databases = include($this->configuration->getConfigCache()->checkConfig('config/databases.yml'));
    }
    else
    {
      $configHandler = new sfDatabaseConfigHandler();
      $databases = $configHandler->evaluate(array($this->configuration->getRootDir().'/config/databases.yml'));
    }
    foreach ($databases as $name => $database)
    {
      $this->setDatabase($name, $database);
    }
  }
  public function setDatabase($name, sfDatabase $database)
  {
    $this->databases[$name] = $database;
  }
  public function getDatabase($name = 'default')
  {
    if (isset($this->databases[$name]))
    {
      return $this->databases[$name];
    }
        throw new sfDatabaseException(sprintf('Database "%s" does not exist.', $name));
  }
  public function getNames()
  {
    return array_keys($this->databases);
  }
  public function shutdown()
  {
        foreach ($this->databases as $database)
    {
      $database->shutdown();
    }
  }
}

abstract class sfFilter
{
  protected $parameterHolder = null;
  protected $context = null;
  public static
    $filterCalled    = array();
  public function __construct($context, $parameters = array())
  {
    $this->initialize($context, $parameters);
  }
  public function initialize($context, $parameters = array())
  {
    $this->context = $context;
    $this->parameterHolder = new sfParameterHolder();
    $this->parameterHolder->add($parameters);
    return true;
  }
  protected function isFirstCall()
  {
    $class = get_class($this);
    if (isset(self::$filterCalled[$class]))
    {
      return false;
    }
    else
    {
      self::$filterCalled[$class] = true;
      return true;
    }
  }
  public final function getContext()
  {
    return $this->context;
  }
  public function getParameterHolder()
  {
    return $this->parameterHolder;
  }
  public function getParameter($name, $default = null)
  {
    return $this->parameterHolder->get($name, $default);
  }
  public function hasParameter($name)
  {
    return $this->parameterHolder->has($name);
  }
  public function setParameter($name, $value)
  {
    return $this->parameterHolder->set($name, $value);
  }
}

class sfExecutionFilter extends sfFilter
{
  public function execute($filterChain)
  {
    $actionInstance = $this->context->getController()->getActionStack()->getLastEntry()->getActionInstance();
        if (sfConfig::get('sf_debug') && sfConfig::get('sf_logging_enabled'))
    {
      $timer = sfTimerManager::getTimer(sprintf('Action "%s/%s"', $actionInstance->getModuleName(), $actionInstance->getActionName()));
      $viewName = $this->handleAction($filterChain, $actionInstance);
      $timer->addTime();
      $timer = sfTimerManager::getTimer(sprintf('View "%s" for "%s/%s"', $viewName, $actionInstance->getModuleName(), $actionInstance->getActionName()));
      $this->handleView($filterChain, $actionInstance, $viewName);
      $timer->addTime();
    }
    else
    {
      $viewName = $this->handleAction($filterChain, $actionInstance);
      $this->handleView($filterChain, $actionInstance, $viewName);
    }
  }
  protected function handleAction($filterChain, $actionInstance)
  {
    if (sfConfig::get('sf_cache'))
    {
      $uri = $this->context->getViewCacheManager()->getCurrentCacheKey();
      if (null !== $uri && $this->context->getViewCacheManager()->hasActionCache($uri))
      {
                return sfView::SUCCESS;
      }
    }
    return $this->executeAction($actionInstance);
  }
  protected function executeAction($actionInstance)
  {
        $actionInstance->preExecute();
    $viewName = $actionInstance->execute($this->context->getRequest());
    $actionInstance->postExecute();
    return null === $viewName ? sfView::SUCCESS : $viewName;
  }
  protected function handleView($filterChain, $actionInstance, $viewName)
  {
    switch ($viewName)
    {
      case sfView::HEADER_ONLY:
        $this->context->getResponse()->setHeaderOnly(true);
        return;
      case sfView::NONE:
        return;
    }
    $this->executeView($actionInstance->getModuleName(), $actionInstance->getActionName(), $viewName, $actionInstance->getVarHolder()->getAll());
  }
  protected function executeView($moduleName, $actionName, $viewName, $viewAttributes)
  {
    $controller = $this->context->getController();
        $view = $controller->getView($moduleName, $actionName, $viewName);
        $view->execute();
        $view->getAttributeHolder()->add($viewAttributes);
        switch ($controller->getRenderMode())
    {
      case sfView::RENDER_NONE:
        break;
      case sfView::RENDER_CLIENT:
        $viewData = $view->render();
        $this->context->getResponse()->setContent($viewData);
        break;
      case sfView::RENDER_VAR:
        $viewData = $view->render();
        $controller->getActionStack()->getLastEntry()->setPresentation($viewData);
        break;
    }
  }
}

class sfRenderingFilter extends sfFilter
{
  public function execute($filterChain)
  {
        $filterChain->execute();
        $response = $this->context->getResponse();
        if (sfForm::hasToStringException())
    {
      throw sfForm::getToStringException();
    }
    else if (sfFormField::hasToStringException())
    {
      throw sfFormField::getToStringException();
    }
        if (sfView::RENDER_VAR != $this->context->getController()->getRenderMode())
    {
        $response->send();
    }
  }
}

class sfFilterChain
{
  protected
    $chain = array(),
    $index = -1;
  public function loadConfiguration($actionInstance)
  {
    require(sfContext::getInstance()->getConfigCache()->checkConfig('modules/'.$actionInstance->getModuleName().'/config/filters.yml'));
  }
  public function execute()
  {
        ++$this->index;
    if ($this->index < count($this->chain))
    {
      if (sfConfig::get('sf_logging_enabled'))
      {
        sfContext::getInstance()->getEventDispatcher()->notify(new sfEvent($this, 'application.log', array(sprintf('Executing filter "%s"', get_class($this->chain[$this->index])))));
      }
            $this->chain[$this->index]->execute($this);
    }
  }
  public function hasFilter($class)
  {
    foreach ($this->chain as $filter)
    {
      if ($filter instanceof $class)
      {
        return true;
      }
    }
    return false;
  }
  public function register($filter)
  {
    $this->chain[] = $filter;
  }
}

abstract class sfLogger implements sfLoggerInterface
{
  const EMERG   = 0;   const ALERT   = 1;   const CRIT    = 2;   const ERR     = 3;   const WARNING = 4;   const NOTICE  = 5;   const INFO    = 6;   const DEBUG   = 7;
  protected $dispatcher = null;
  protected $options = array();
  protected $level = self::INFO;
  public function __construct(sfEventDispatcher $dispatcher, $options = array())
  {
    $this->initialize($dispatcher, $options);
    if (!isset($options['auto_shutdown']) || $options['auto_shutdown'])
    {
      register_shutdown_function(array($this, 'shutdown'));
    }
  }
  public function initialize(sfEventDispatcher $dispatcher, $options = array())
  {
    $this->dispatcher = $dispatcher;
    $this->options = $options;
    if (isset($this->options['level']))
    {
      $this->setLogLevel($this->options['level']);
    }
    $dispatcher->connect('application.log', array($this, 'listenToLogEvent'));
  }
  public function getOptions()
  {
    return $this->options;
  }
  public function setOption($name, $value)
  {
    $this->options[$name] = $value;
  }
  public function getLogLevel()
  {
    return $this->level;
  }
  public function setLogLevel($level)
  {
    if (!is_int($level))
    {
      $level = constant('sfLogger::'.strtoupper($level));
    }
    $this->level = $level;
  }
  public function log($message, $priority = self::INFO)
  {
    if ($this->getLogLevel() < $priority)
    {
      return false;
    }
    $this->doLog($message, $priority);
  }
  abstract protected function doLog($message, $priority);
  public function emerg($message)
  {
    $this->log($message, self::EMERG);
  }
  public function alert($message)
  {
    $this->log($message, self::ALERT);
  }
  public function crit($message)
  {
    $this->log($message, self::CRIT);
  }
  public function err($message)
  {
    $this->log($message, self::ERR);
  }
  public function warning($message)
  {
    $this->log($message, self::WARNING);
  }
  public function notice($message)
  {
    $this->log($message, self::NOTICE);
  }
  public function info($message)
  {
    $this->log($message, self::INFO);
  }
  public function debug($message)
  {
    $this->log($message, self::DEBUG);
  }
  public function listenToLogEvent(sfEvent $event)
  {
    $priority = isset($event['priority']) ? $event['priority'] : self::INFO;
    $subject  = $event->getSubject();
    $subject  = is_object($subject) ? get_class($subject) : (is_string($subject) ? $subject : 'main');
    foreach ($event->getParameters() as $key => $message)
    {
      if ('priority' === $key)
      {
        continue;
      }
      $this->log(sprintf('{%s} %s', $subject, $message), $priority);
    }
  }
  public function shutdown()
  {
  }
  static public function getPriorityName($priority)
  {
    static $levels  = array(
      self::EMERG   => 'emerg',
      self::ALERT   => 'alert',
      self::CRIT    => 'crit',
      self::ERR     => 'err',
      self::WARNING => 'warning',
      self::NOTICE  => 'notice',
      self::INFO    => 'info',
      self::DEBUG   => 'debug',
    );
    if (!isset($levels[$priority]))
    {
      throw new sfException(sprintf('The priority level "%s" does not exist.', $priority));
    }
    return $levels[$priority];
  }
}

class sfNoLogger extends sfLogger
{
  public function initialize(sfEventDispatcher $dispatcher, $options = array())
  {
  }
  protected function doLog($message, $priority)
  {
  }
}

abstract class sfRequest implements ArrayAccess
{
  const GET    = 'GET';
  const POST   = 'POST';
  const PUT    = 'PUT';
  const PATCH  = 'PATCH';
  const DELETE = 'DELETE';
  const HEAD   = 'HEAD';
  const OPTIONS = 'OPTIONS';
  protected $dispatcher = null;
  protected $content = null;
  protected $method = null;
  protected $options = array();
  protected $parameterHolder = null;
  protected $attributeHolder = null;
  public function __construct(sfEventDispatcher $dispatcher, $parameters = array(), $attributes = array(), $options = array())
  {
    $this->initialize($dispatcher, $parameters, $attributes, $options);
  }
  public function initialize(sfEventDispatcher $dispatcher, $parameters = array(), $attributes = array(), $options = array())
  {
    $this->dispatcher = $dispatcher;
    $this->options = $options;
    if (!isset($this->options['logging']))
    {
      $this->options['logging'] = false;
    }
        $this->parameterHolder = new sfParameterHolder();
    $this->attributeHolder = new sfParameterHolder();
    $this->parameterHolder->add($parameters);
    $this->attributeHolder->add($attributes);
  }
  public function getOption($name)
  {
    return isset($this->options[$name]) ? $this->options[$name] : null;
  }
  public function getOptions()
  {
    return $this->options;
  }
  public function extractParameters($names)
  {
    $array = array();
    $parameters = $this->parameterHolder->getAll();
    foreach ($parameters as $key => $value)
    {
      if (in_array($key, $names))
      {
        $array[$key] = $value;
      }
    }
    return $array;
  }
  public function getMethod()
  {
    return $this->method;
  }
  public function setMethod($method)
  {
    if (!in_array(strtoupper($method), array(self::GET, self::POST, self::PUT, self::PATCH, self::DELETE, self::HEAD, self::OPTIONS)))
    {
      throw new sfException(sprintf('Invalid request method: %s.', $method));
    }
    $this->method = strtoupper($method);
  }
  public function offsetExists($name)
  {
    return $this->hasParameter($name);
  }
  public function offsetGet($name)
  {
    return $this->getParameter($name, false);
  }
  public function offsetSet($offset, $value)
  {
    $this->setParameter($offset, $value);
  }
  public function offsetUnset($offset)
  {
    $this->getParameterHolder()->remove($offset);
  }
  public function getParameterHolder()
  {
    return $this->parameterHolder;
  }
  public function getAttributeHolder()
  {
    return $this->attributeHolder;
  }
  public function getAttribute($name, $default = null)
  {
    return $this->attributeHolder->get($name, $default);
  }
  public function hasAttribute($name)
  {
    return $this->attributeHolder->has($name);
  }
  public function setAttribute($name, $value)
  {
    $this->attributeHolder->set($name, $value);
  }
  public function getParameter($name, $default = null)
  {
    return $this->parameterHolder->get($name, $default);
  }
  public function hasParameter($name)
  {
    return $this->parameterHolder->has($name);
  }
  public function setParameter($name, $value)
  {
    $this->parameterHolder->set($name, $value);
  }
  public function getContent()
  {
    if (null === $this->content && '' === trim($this->content = file_get_contents('php://input')))
    {
      $this->content = false;
    }
    return $this->content;
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'request.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
  public function __clone()
  {
    $this->parameterHolder = clone $this->parameterHolder;
    $this->attributeHolder = clone $this->attributeHolder;
  }
}

abstract class sfResponse implements Serializable
{
  protected $options = array();
  protected $dispatcher = null;
  protected $content = '';
  public function __construct(sfEventDispatcher $dispatcher, $options = array())
  {
    $this->initialize($dispatcher, $options);
  }
  public function initialize(sfEventDispatcher $dispatcher, $options = array())
  {
    $this->dispatcher = $dispatcher;
    $this->options = $options;
    if (!isset($this->options['logging']))
    {
      $this->options['logging'] = false;
    }
  }
  public function setEventDispatcher(sfEventDispatcher $dispatcher)
  {
    $this->dispatcher = $dispatcher;
  }
  public function setContent($content)
  {
    $this->content = $content;
  }
  public function getContent()
  {
    return $this->content;
  }
  public function sendContent()
  {
    $event = $this->dispatcher->filter(new sfEvent($this, 'response.filter_content'), $this->getContent());
    $content = $event->getReturnValue();
    if ($this->options['logging'])
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Send content (%s o)', strlen($content)))));
    }
    echo $content;
  }
  public function send()
  {
    $this->sendContent();
  }
  public function getOptions()
  {
    return $this->options;
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'response.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
  public function serialize()
  {
    return serialize($this->content);
  }
  public function unserialize($serialized)
  {
    $this->content = unserialize($serialized);
  }
}

abstract class sfRouting
{
  protected $dispatcher = null;
  protected $cache = null;
  protected $defaultParameters = array();
  protected $options = array();
  public function __construct(sfEventDispatcher $dispatcher, sfCache $cache = null, $options = array())
  {
    $this->initialize($dispatcher, $cache, $options);
    if (!isset($this->options['auto_shutdown']) || $this->options['auto_shutdown'])
    {
      register_shutdown_function(array($this, 'shutdown'));
    }
  }
  public function getCache()
  {
    return $this->cache;
  }
  public function initialize(sfEventDispatcher $dispatcher, sfCache $cache = null, $options = array())
  {
    $this->dispatcher = $dispatcher;
    $options['debug'] = isset($options['debug']) ? (boolean) $options['debug'] : false;
        $this->cache = $options['debug'] ? null : $cache;
    $this->setDefaultParameter('module', isset($options['default_module']) ? $options['default_module'] : 'default');
    $this->setDefaultParameter('action', isset($options['default_action']) ? $options['default_action'] : 'index');
    if (!isset($options['logging']))
    {
      $options['logging'] = false;
    }
    if (!isset($options['context']))
    {
      $options['context'] = array();
    }
    $this->options = $options;
    $this->dispatcher->connect('user.change_culture', array($this, 'listenToChangeCultureEvent'));
    $this->dispatcher->connect('request.filter_parameters', array($this, 'filterParametersEvent'));
    $this->loadConfiguration();
  }
  public function getOptions()
  {
    return $this->options;
  }
  public function loadConfiguration()
  {
    $this->dispatcher->notify(new sfEvent($this, 'routing.load_configuration'));
  }
  abstract public function getCurrentInternalUri($with_route_name = false);
  abstract public function getRoutes();
  abstract public function getRoute($name);
  abstract public function setRoutes($routes);
  abstract public function hasRoutes();
  abstract public function clearRoutes();
  abstract public function generate($name, $params = array(), $absolute = false);
  abstract public function parse($url);
  public function getDefaultParameters()
  {
    return $this->defaultParameters;
  }
  public function getDefaultParameter($key)
  {
    return isset($this->defaultParameters[$key]) ? $this->defaultParameters[$key] : null;
  }
  public function setDefaultParameter($key, $value)
  {
    $this->defaultParameters[$key] = $value;
  }
  public function setDefaultParameters($parameters)
  {
    $this->defaultParameters = $parameters;
  }
  public function listenToChangeCultureEvent(sfEvent $event)
  {
        $this->setDefaultParameter('sf_culture', $event['culture']);
  }
  public function filterParametersEvent(sfEvent $event, $parameters)
  {
    $context = $event->getParameters();
    $this->options['context'] = $context;
    if (false === $params = $this->parse($event['path_info']))
    {
      return $parameters;
    }
    return array_merge($parameters, $params);
  }
  protected function fixGeneratedUrl($url, $absolute = false)
  {
    if (isset($this->options['context']['prefix']))
    {
      if (0 === strpos($url, 'http'))
      {
        $url = preg_replace('#https?\://[^/]+#', '$0'.$this->options['context']['prefix'], $url);
      }
      else
      {
        $url = $this->options['context']['prefix'].$url;
      }
    }
    if ($absolute && isset($this->options['context']['host']) && 0 !== strpos($url, 'http'))
    {
      $url = 'http'.(isset($this->options['context']['is_secure']) && $this->options['context']['is_secure'] ? 's' : '').'://'.$this->options['context']['host'].$url;
    }
    return $url;
  }
  public function shutdown()
  {
  }
}

abstract class sfStorage
{
  protected
    $options = array();
  public function __construct($options = array())
  {
    $this->initialize($options);
    if ($this->options['auto_shutdown'])
    {
      register_shutdown_function(array($this, 'shutdown'));
    }
  }
  public function initialize($options = array())
  {
    $this->options = array_merge(array(
      'auto_shutdown' => true,
    ), $options);
  }
  public function getOptions()
  {
    return $this->options;
  }
  abstract public function read($key);
  abstract public function regenerate($destroy = false);
  abstract public function remove($key);
  abstract public function shutdown();
  abstract public function write($key, $data);
}

class sfUser implements ArrayAccess
{
  const ATTRIBUTE_NAMESPACE = 'symfony/user/sfUser/attributes';
  const CULTURE_NAMESPACE = 'symfony/user/sfUser/culture';
  protected $options = array();
  protected $attributeHolder = null;
  protected $culture = null;
  protected $storage = null;
  protected $dispatcher = null;
  public function __construct(sfEventDispatcher $dispatcher, sfStorage $storage, $options = array())
  {
    $this->initialize($dispatcher, $storage, $options);
    if ($this->options['auto_shutdown'])
    {
      register_shutdown_function(array($this, 'shutdown'));
    }
  }
  public function initialize(sfEventDispatcher $dispatcher, sfStorage $storage, $options = array())
  {
    $this->dispatcher = $dispatcher;
    $this->storage    = $storage;
    $this->options = array_merge(array(
      'auto_shutdown'   => true,
      'culture'         => null,
      'default_culture' => 'en',
      'use_flash'       => false,
      'logging'         => false,
    ), $options);
    $this->attributeHolder = new sfNamespacedParameterHolder(self::ATTRIBUTE_NAMESPACE);
        $attributes = $storage->read(self::ATTRIBUTE_NAMESPACE);
    if (is_array($attributes))
    {
      foreach ($attributes as $namespace => $values)
      {
        $this->attributeHolder->add($values, $namespace);
      }
    }
                    $currentCulture = $storage->read(self::CULTURE_NAMESPACE);
    $this->setCulture(null !== $this->options['culture'] ? $this->options['culture'] : (null !== $currentCulture ? $currentCulture : $this->options['default_culture']));
        if ($this->options['use_flash'] && $names = $this->attributeHolder->getNames('symfony/user/sfUser/flash'))
    {
      if ($this->options['logging'])
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Flag old flash messages ("%s")', implode('", "', $names)))));
      }
      foreach ($names as $name)
      {
        $this->attributeHolder->set($name, true, 'symfony/user/sfUser/flash/remove');
      }
    }
  }
  public function getOptions()
  {
    return $this->options;
  }
  public function setCulture($culture)
  {
    if ($this->culture != $culture)
    {
      $this->culture = $culture;
      $this->dispatcher->notify(new sfEvent($this, 'user.change_culture', array('culture' => $culture)));
    }
  }
  public function setFlash($name, $value, $persist = true)
  {
    if (!$this->options['use_flash'])
    {
      return;
    }
    $this->setAttribute($name, $value, 'symfony/user/sfUser/flash');
    if ($persist)
    {
            $this->attributeHolder->remove($name, null, 'symfony/user/sfUser/flash/remove');
    }
    else
    {
      $this->setAttribute($name, true, 'symfony/user/sfUser/flash/remove');
    }
  }
  public function getFlash($name, $default = null)
  {
    if (!$this->options['use_flash'])
    {
      return $default;
    }
    return $this->getAttribute($name, $default, 'symfony/user/sfUser/flash');
  }
  public function hasFlash($name)
  {
    if (!$this->options['use_flash'])
    {
      return false;
    }
    return $this->hasAttribute($name, 'symfony/user/sfUser/flash');
  }
  public function getCulture()
  {
    return $this->culture;
  }
  public function offsetExists($name)
  {
    return $this->hasAttribute($name);
  }
  public function offsetGet($name)
  {
    return $this->getAttribute($name, false);
  }
  public function offsetSet($offset, $value)
  {
    $this->setAttribute($offset, $value);
  }
  public function offsetUnset($offset)
  {
    $this->getAttributeHolder()->remove($offset);
  }
  public function getAttributeHolder()
  {
    return $this->attributeHolder;
  }
  public function getAttribute($name, $default = null, $ns = null)
  {
    return $this->attributeHolder->get($name, $default, $ns);
  }
  public function hasAttribute($name, $ns = null)
  {
    return $this->attributeHolder->has($name, $ns);
  }
  public function setAttribute($name, $value, $ns = null)
  {
    return $this->attributeHolder->set($name, $value, $ns);
  }
  public function shutdown()
  {
        if ($this->options['use_flash'] && $names = $this->attributeHolder->getNames('symfony/user/sfUser/flash/remove'))
    {
      if ($this->options['logging'])
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Remove old flash messages ("%s")', implode('", "', $names)))));
      }
      foreach ($names as $name)
      {
        $this->attributeHolder->remove($name, null, 'symfony/user/sfUser/flash');
        $this->attributeHolder->remove($name, null, 'symfony/user/sfUser/flash/remove');
      }
    }
    $attributes = array();
    foreach ($this->attributeHolder->getNamespaces() as $namespace)
    {
      $attributes[$namespace] = $this->attributeHolder->getAll($namespace);
    }
        $this->storage->write(self::ATTRIBUTE_NAMESPACE, $attributes);
        $this->storage->write(self::CULTURE_NAMESPACE, $this->culture);
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'user.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
}

class sfNamespacedParameterHolder extends sfParameterHolder
{
  protected $default_namespace = null;
  protected $parameters = array();
  public function __construct($namespace = 'symfony/default')
  {
    $this->default_namespace = $namespace;
  }
  public function setDefaultNamespace($namespace, $move = true)
  {
    if ($move)
    {
      if (null !== $values = $this->removeNamespace())
      {
          $this->addByRef($values, $namespace);
      }
    }
    $this->default_namespace = $namespace;
  }
  public function getDefaultNamespace()
  {
    return $this->default_namespace;
  }
  public function clear()
  {
    $this->parameters = null;
    $this->parameters = array();
  }
  public function & get($name, $default = null, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (isset($this->parameters[$ns][$name]))
    {
      $value = & $this->parameters[$ns][$name];
    }
    else
    {
      $value = $default;
    }
    return $value;
  }
  public function getNames($ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (isset($this->parameters[$ns]))
    {
      return array_keys($this->parameters[$ns]);
    }
    return array();
  }
  public function getNamespaces()
  {
    return array_keys($this->parameters);
  }
  public function & getAll($ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    $parameters = array();
    if (isset($this->parameters[$ns]))
    {
      $parameters = $this->parameters[$ns];
    }
    return $parameters;
  }
  public function has($name, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    return isset($this->parameters[$ns][$name]);
  }
  public function hasNamespace($ns)
  {
    return isset($this->parameters[$ns]);
  }
  public function remove($name, $default = null, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    $retval = $default;
    if (isset($this->parameters[$ns]) && array_key_exists($name, $this->parameters[$ns]))
    {
      $retval = $this->parameters[$ns][$name];
      unset($this->parameters[$ns][$name]);
    }
    return $retval;
  }
  public function & removeNamespace($ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    $retval = null;
    if (isset($this->parameters[$ns]))
    {
      $retval =& $this->parameters[$ns];
      unset($this->parameters[$ns]);
    }
    return $retval;
  }
  public function set($name, $value, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (!isset($this->parameters[$ns]))
    {
      $this->parameters[$ns] = array();
    }
    $this->parameters[$ns][$name] = $value;
  }
  public function setByRef($name, & $value, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (!isset($this->parameters[$ns]))
    {
      $this->parameters[$ns] = array();
    }
    $this->parameters[$ns][$name] =& $value;
  }
  public function add($parameters, $ns = null)
  {
    if ($parameters === null) return;
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (!isset($this->parameters[$ns]))
    {
      $this->parameters[$ns] = array();
    }
    foreach ($parameters as $key => $value)
    {
      $this->parameters[$ns][$key] = $value;
    }
  }
  public function addByRef(& $parameters, $ns = null)
  {
    if (!$ns)
    {
      $ns = $this->default_namespace;
    }
    if (!isset($this->parameters[$ns]))
    {
      $this->parameters[$ns] = array();
    }
    foreach ($parameters as $key => &$value)
    {
      $this->parameters[$ns][$key] =& $value;
    }
  }
  public function serialize()
  {
    return serialize(array($this->default_namespace, $this->parameters));
  }
  public function unserialize($serialized)
  {
    $data = unserialize($serialized);
    $this->default_namespace = $data[0];
    $this->parameters = $data[1];
  }
}

abstract class sfView
{
  const ALERT = 'Alert';
  const ERROR = 'Error';
  const INPUT = 'Input';
  const NONE = 'None';
  const SUCCESS = 'Success';
  const RENDER_NONE = 1;
  const RENDER_CLIENT = 2;
  const RENDER_VAR = 4;
  const HEADER_ONLY = 8;
  protected
    $context            = null,
    $dispatcher         = null,
    $decorator          = false,
    $decoratorDirectory = null,
    $decoratorTemplate  = null,
    $directory          = null,
    $componentSlots     = array(),
    $template           = null,
    $attributeHolder    = null,
    $parameterHolder    = null,
    $moduleName         = '',
    $actionName         = '',
    $viewName           = '',
    $extension          = '.php';
  public function __construct($context, $moduleName, $actionName, $viewName)
  {
    $this->initialize($context, $moduleName, $actionName, $viewName);
  }
  public function initialize($context, $moduleName, $actionName, $viewName)
  {
    $this->moduleName = $moduleName;
    $this->actionName = $actionName;
    $this->viewName   = $viewName;
    $this->context    = $context;
    $this->dispatcher = $context->getEventDispatcher();
    sfOutputEscaper::markClassesAsSafe(array('sfForm', 'sfFormField', 'sfFormFieldSchema', 'sfModelGeneratorHelper'));
    $this->attributeHolder = $this->initializeAttributeHolder();
    $this->parameterHolder = new sfParameterHolder();
    $this->parameterHolder->add(sfConfig::get('mod_'.strtolower($moduleName).'_view_param', array()));
    $request = $context->getRequest();
    $format = $request->getRequestFormat();
    if (null !== $format)
    {
      if ('html' != $format)
      {
        $this->setExtension('.'.$format.$this->getExtension());
      }
      if ($mimeType = $request->getMimeType($format))
      {
        $this->context->getResponse()->setContentType($mimeType);
        if ('html' != $format)
        {
          $this->setDecorator(false);
        }
      }
    }
    $this->dispatcher->notify(new sfEvent($this, 'view.configure_format', array('format' => $format, 'response' => $context->getResponse(), 'request' => $context->getRequest())));
        $this->configure();
    return true;
  }
  protected function initializeAttributeHolder($attributes = array())
  {
    $attributeHolder = new sfViewParameterHolder($this->dispatcher, $attributes, array(
      'escaping_method'   => sfConfig::get('sf_escaping_method'),
      'escaping_strategy' => sfConfig::get('sf_escaping_strategy'),
    ));
    return $attributeHolder;
  }
  abstract function execute();
  abstract function configure();
  public function getDecoratorDirectory()
  {
    return $this->decoratorDirectory;
  }
  public function getDecoratorTemplate()
  {
    return $this->decoratorTemplate;
  }
  public function getDirectory()
  {
    return $this->directory;
  }
  abstract function getEngine();
  public function getTemplate()
  {
    return $this->template;
  }
  public function getAttributeHolder()
  {
    return $this->attributeHolder;
  }
  public function getAttribute($name, $default = null)
  {
    return $this->attributeHolder->get($name, $default);
  }
  public function hasAttribute($name)
  {
    return $this->attributeHolder->has($name);
  }
  public function setAttribute($name, $value)
  {
    $this->attributeHolder->set($name, $value);
  }
  public function getParameterHolder()
  {
    return $this->parameterHolder;
  }
  public function getParameter($name, $default = null)
  {
    return $this->parameterHolder->get($name, $default);
  }
  public function hasParameter($name)
  {
    return $this->parameterHolder->has($name);
  }
  public function setParameter($name, $value)
  {
    $this->parameterHolder->set($name, $value);
  }
  public function isDecorator()
  {
    return $this->decorator;
  }
  public function setDecorator($boolean)
  {
    $this->decorator = (boolean) $boolean;
    if (false === $boolean)
    {
      $this->decoratorTemplate = false;
    }
  }
  protected function preRenderCheck()
  {
    if (null === $this->template)
    {
            throw new sfRenderException('A template has not been set.');
    }
    if (!is_readable($this->directory.'/'.$this->template))
    {
            if ('404' == $this->context->getResponse()->getStatusCode())
      {
                $this->template = sfException::getTemplatePathForError($this->context->getRequest()->getRequestFormat(), false);
        $this->directory = dirname($this->template);
        $this->template = basename($this->template);
        $this->setAttribute('code', '404');
        $this->setAttribute('text', 'Not Found');
      }
      else
      {
        throw new sfRenderException(sprintf('The template "%s" does not exist or is unreadable in "%s".', $this->template, $this->directory));
      }
    }
  }
  abstract function render();
  public function setDecoratorDirectory($directory)
  {
    $this->decoratorDirectory = $directory;
  }
  public function setDecoratorTemplate($template)
  {
    if (false === $template)
    {
      $this->setDecorator(false);
      return;
    }
    else if (null === $template)
    {
      return;
    }
    if (!strpos($template, '.'))
    {
      $template .= $this->getExtension();
    }
    if (sfToolkit::isPathAbsolute($template))
    {
      $this->decoratorDirectory = dirname($template);
      $this->decoratorTemplate  = basename($template);
    }
    else
    {
      $this->decoratorDirectory = $this->context->getConfiguration()->getDecoratorDir($template);
      $this->decoratorTemplate = $template;
    }
        $this->decorator = true;
  }
  public function setDirectory($directory)
  {
    $this->directory = $directory;
  }
  public function setComponentSlot($attributeName, $moduleName, $componentName)
  {
    $this->componentSlots[$attributeName]                   = array();
    $this->componentSlots[$attributeName]['module_name']    = $moduleName;
    $this->componentSlots[$attributeName]['component_name'] = $componentName;
  }
  public function hasComponentSlot($name)
  {
    return isset($this->componentSlots[$name]);
  }
  public function getComponentSlot($name)
  {
    if (isset($this->componentSlots[$name]) && $this->componentSlots[$name]['module_name'] && $this->componentSlots[$name]['component_name'])
    {
      return array($this->componentSlots[$name]['module_name'], $this->componentSlots[$name]['component_name']);
    }
    return null;
  }
  public function setTemplate($template)
  {
    if (sfToolkit::isPathAbsolute($template))
    {
      $this->directory = dirname($template);
      $this->template  = basename($template);
    }
    else
    {
      $this->directory = $this->context->getConfiguration()->getTemplateDir($this->moduleName, $template);
      $this->template = $template;
    }
  }
  public function getExtension()
  {
    return $this->extension;
  }
  public function setExtension($extension)
  {
    $this->extension = $extension;
  }
  public function getModuleName()
  {
    return $this->moduleName;
  }
  public function getActionName()
  {
    return $this->actionName;
  }
  public function getViewName()
  {
    return $this->viewName;
  }
  public function __call($method, $arguments)
  {
    $event = $this->dispatcher->notifyUntil(new sfEvent($this, 'view.method_not_found', array('method' => $method, 'arguments' => $arguments)));
    if (!$event->isProcessed())
    {
      throw new sfException(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
    }
    return $event->getReturnValue();
  }
}

class sfViewParameterHolder extends sfParameterHolder
{
  protected
    $dispatcher     = null,
    $escaping       = null,
    $escapingMethod = null;
  public function __construct(sfEventDispatcher $dispatcher, $parameters = array(), $options = array())
  {
    $this->initialize($dispatcher, $parameters, $options);
  }
  public function initialize(sfEventDispatcher $dispatcher, $parameters = array(), $options = array())
  {
    $this->dispatcher = $dispatcher;
    $this->add($parameters);
    $this->setEscaping(isset($options['escaping_strategy']) ? $options['escaping_strategy'] : false);
    $this->setEscapingMethod(isset($options['escaping_method']) ? $options['escaping_method'] : 'ESC_SPECIALCHARS');
  }
  public function isEscaped()
  {
    return in_array($this->getEscaping(), array('on', 'true', true), true);
  }
  public function toArray()
  {
    $event = $this->dispatcher->filter(new sfEvent($this, 'template.filter_parameters'), $this->getAll());
    $parameters = $event->getReturnValue();
    $attributes = array();
    if ($this->isEscaped())
    {
      $attributes['sf_data'] = sfOutputEscaper::escape($this->getEscapingMethod(), $parameters);
      foreach ($attributes['sf_data'] as $key => $value)
      {
        $attributes[$key] = $value;
      }
    }
    else if (in_array($this->getEscaping(), array('off', false), true))
    {
      $attributes = $parameters;
      $attributes['sf_data'] = sfOutputEscaper::escape(ESC_RAW, $parameters);
    }
    else
    {
      throw new InvalidArgumentException(sprintf('Unknown strategy "%s".', $this->getEscaping()));
    }
    return $attributes;
  }
  public function getEscaping()
  {
    return $this->escaping;
  }
  public function setEscaping($escaping)
  {
    $this->escaping = $escaping;
  }
  public function getEscapingMethod()
  {
    if (empty($this->escapingMethod))
    {
      return $this->escapingMethod;
    }
    if (!defined($this->escapingMethod))
    {
      throw new InvalidArgumentException(sprintf('The escaping method "%s" is not available.', $this->escapingMethod));
    }
    return constant($this->escapingMethod);
  }
  public function setEscapingMethod($method)
  {
    $this->escapingMethod = $method;
  }
  public function serialize()
  {
    return serialize(array($this->getAll(), $this->escapingMethod, $this->escaping));
  }
  public function unserialize($serialized)
  {
    list($this->parameters, $escapingMethod, $escaping) = unserialize($serialized);
    $this->initialize(sfContext::hasInstance() ? sfContext::getInstance()->getEventDispatcher() : new sfEventDispatcher());
    $this->setEscapingMethod($escapingMethod);
    $this->setEscaping($escaping);
  }
}

interface sfServiceContainerLoaderInterface
{
  function load($resource);
}

interface sfServiceContainerInterface
{
  public function setParameters(array $parameters);
  public function addParameters(array $parameters);
  public function getParameters();
  public function getParameter($name);
  public function setParameter($name, $value);
  public function hasParameter($name);
  public function setService($id, $service);
  public function getService($id);
  public function hasService($id);
}

class sfServiceContainer implements sfServiceContainerInterface
{
  protected
    $serviceIds = array(),
    $parameters = array(),
    $services   = array(),
    $count      = 0;
  public function __construct(array $parameters = array())
  {
    $this->setParameters($parameters);
    $this->setService('service_container', $this);
  }
  public function setParameters(array $parameters)
  {
    $this->parameters = array();
    foreach ($parameters as $key => $value)
    {
      $this->parameters[strtolower($key)] = $value;
    }
  }
  public function addParameters(array $parameters)
  {
    $this->setParameters(array_merge($this->parameters, $parameters));
  }
  public function getParameters()
  {
    return $this->parameters;
  }
  public function getParameter($name)
  {
    if ($this->hasParameter($name))
    {
      return $this->parameters[strtolower($name)];
    }
    if (sfConfig::has($name))
    {
      return sfConfig::get($name);
    }
    throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
  }
  public function setParameter($name, $value)
  {
    $this->parameters[strtolower($name)] = $value;
  }
  public function hasParameter($name)
  {
    return array_key_exists(strtolower($name), $this->parameters);
  }
  public function setService($id, $service)
  {
    $this->services[$id] = $service;
  }
  public function hasService($id)
  {
    return isset($this->services[$id]) || method_exists($this, 'get'.self::camelize($id).'Service');
  }
  public function getService($id)
  {
    if (isset($this->services[$id]))
    {
      return $this->services[$id];
    }
    if (method_exists($this, $method = 'get'.self::camelize($id).'Service'))
    {
      return $this->$method();
    }
    throw new InvalidArgumentException(sprintf('The service "%s" does not exist.', $id));
  }
  public function getServiceIds()
  {
    $ids = array();
    $r = new ReflectionClass($this);
    foreach ($r->getMethods() as $method)
    {
      if (preg_match('/^get(.+)Service$/', $name = $method->getName(), $match))
      {
        $ids[] = self::underscore($match[1]);
      }
    }
    return array_merge($ids, array_keys($this->services));
  }
  static public function camelize($id)
  {
    return strtr(ucwords(strtr($id, array('_' => ' ', '-' => ' ', '.' => '_ '))), array(' ' => ''));
  }
  static public function underscore($id)
  {
    return strtolower(preg_replace(array('/_/', '/([A-Z]+)([A-Z][a-z])/', '/([a-z\d])([A-Z])/'), array('.', '\\1_\\2', '\\1_\\2'), $id));
  }
}

class sfServiceContainerBuilder extends sfServiceContainer
{
  protected
    $definitions = array(),
    $aliases     = array(),
    $loading     = array();
  public function setService($id, $service)
  {
    unset($this->aliases[$id]);
    parent::setService($id, $service);
  }
  public function hasService($id)
  {
    return isset($this->definitions[$id]) || isset($this->aliases[$id]) || parent::hasService($id);
  }
  public function getService($id)
  {
    try
    {
      return parent::getService($id);
    }
    catch (InvalidArgumentException $e)
    {
      if (isset($this->loading[$id]))
      {
        throw new LogicException(sprintf('The service "%s" has a circular reference to itself.', $id));
      }
      if (!$this->hasServiceDefinition($id) && isset($this->aliases[$id]))
      {
        return $this->getService($this->aliases[$id]);
      }
      $definition = $this->getServiceDefinition($id);
      $this->loading[$id] = true;
      if ($definition->isShared())
      {
        $service = $this->services[$id] = $this->createService($definition);
      }
      else
      {
        $service = $this->createService($definition);
      }
      unset($this->loading[$id]);
      return $service;
    }
  }
  public function getServiceIds()
  {
    return array_unique(array_merge(array_keys($this->getServiceDefinitions()), array_keys($this->aliases), parent::getServiceIds()));
  }
  public function setAlias($alias, $id)
  {
    $this->aliases[$alias] = $id;
  }
  public function getAliases()
  {
    return $this->aliases;
  }
  public function register($id, $class)
  {
    return $this->setServiceDefinition($id, new sfServiceDefinition($class));
  }
  public function addServiceDefinitions(array $definitions)
  {
    foreach ($definitions as $id => $definition)
    {
      $this->setServiceDefinition($id, $definition);
    }
  }
  public function setServiceDefinitions(array $definitions)
  {
    $this->definitions = array();
    $this->addServiceDefinitions($definitions);
  }
  public function getServiceDefinitions()
  {
    return $this->definitions;
  }
  public function setServiceDefinition($id, sfServiceDefinition $definition)
  {
    unset($this->aliases[$id]);
    return $this->definitions[$id] = $definition;
  }
  public function hasServiceDefinition($id)
  {
    return array_key_exists($id, $this->definitions);
  }
  public function getServiceDefinition($id)
  {
    if (!$this->hasServiceDefinition($id))
    {
      throw new InvalidArgumentException(sprintf('The service definition "%s" does not exist.', $id));
    }
    return $this->definitions[$id];
  }
  protected function createService(sfServiceDefinition $definition)
  {
    if (null !== $definition->getFile())
    {
      require_once $this->resolveValue($definition->getFile());
    }
    $r = new ReflectionClass($this->resolveValue($definition->getClass()));
    $arguments = $this->resolveServices($this->resolveValue($definition->getArguments()));
    if (null !== $definition->getConstructor())
    {
      $service = call_user_func_array(array($this->resolveValue($definition->getClass()), $definition->getConstructor()), $arguments);
    }
    else
    {
      $service = null === $r->getConstructor() ? $r->newInstance() : $r->newInstanceArgs($arguments);
    }
    foreach ($definition->getMethodCalls() as $call)
    {
      call_user_func_array(array($service, $call[0]), $this->resolveServices($this->resolveValue($call[1])));
    }
    if ($callable = $definition->getConfigurator())
    {
      if (is_array($callable) && is_object($callable[0]) && $callable[0] instanceof sfServiceReference)
      {
        $callable[0] = $this->getService((string) $callable[0]);
      }
      elseif (is_array($callable))
      {
        $callable[0] = $this->resolveValue($callable[0]);
      }
      if (!is_callable($callable))
      {
        throw new InvalidArgumentException(sprintf('The configure callable for class "%s" is not a callable.', get_class($service)));
      }
      call_user_func($callable, $service);
    }
    return $service;
  }
  public function resolveValue($value)
  {
    if (is_array($value))
    {
      $args = array();
      foreach ($value as $k => $v)
      {
        $args[$this->resolveValue($k)] = $this->resolveValue($v);
      }
      $value = $args;
    }
    else if (is_string($value))
    {
      if (preg_match('/^%([^%]+)%$/', $value, $match))
      {
        $value = $this->getParameter($match[1]);
      }
      else
      {
        $value = str_replace('%%', '%', preg_replace_callback('/(?<!%)(%)([^%]+)\1/', array($this, 'replaceParameter'), $value));
      }
    }
    return $value;
  }
  public function resolveServices($value)
  {
    if (is_array($value))
    {
      $value = array_map(array($this, 'resolveServices'), $value);
    }
    else if (is_object($value) && $value instanceof sfServiceReference)
    {
      $value = $this->getService((string) $value);
    }
    return $value;
  }
  protected function replaceParameter($match)
  {
    return $this->getParameter($match[2]);
  }
}

abstract class sfServiceContainerLoader implements sfServiceContainerLoaderInterface
{
  protected $container;
  public function __construct(sfServiceContainerBuilder $container = null)
  {
    $this->container = $container;
  }
  public function setServiceContainer(sfServiceContainerBuilder $container)
  {
    $this->container = $container;
  }
  public function load($resource)
  {
    if (!$this->container)
    {
      throw new LogicException('You must attach the loader to a service container.');
    }
    $resources = func_get_args();
    foreach ($resources as $resource)
    {
      list($definitions, $parameters) = $this->doLoad($resource);
      foreach ($definitions as $id => $definition)
      {
        if (is_string($definition))
        {
          $this->container->setAlias($id, $definition);
        }
        else
        {
          $this->container->setServiceDefinition($id, $definition);
        }
      }
      $currentParameters = $this->container->getParameters();
      foreach ($parameters as $key => $value)
      {
        $this->container->setParameter($key, $this->container->resolveValue($value));
      }
      $this->container->addParameters($currentParameters);
    }
  }
  abstract public function doLoad($resource);
}

class sfServiceContainerLoaderArray extends sfServiceContainerLoader
{
  public function doLoad($content)
  {
    $this->validate($content);
    $parameters = array();
    $definitions = array();
        if (isset($content['parameters']))
    {
      foreach ($content['parameters'] as $key => $value)
      {
        $parameters[strtolower($key)] = $this->resolveServices($value);
      }
    }
        if (isset($content['services']))
    {
      foreach ($content['services'] as $id => $service)
      {
        $definitions[$id] = $this->parseDefinition($service);
      }
    }
    return array($definitions, $parameters);
  }
  protected function validate($content)
  {
    if (!is_array($content))
    {
      throw new InvalidArgumentException('The service definition is not valid.');
    }
    foreach (array_keys($content) as $key)
    {
      if (!in_array($key, array('parameters', 'services')))
      {
        throw new InvalidArgumentException(sprintf('The service defintion is not valid ("%s" is not recognized).', $key));
      }
    }
    return $content;
  }
  protected function parseDefinition($service)
  {
    if (is_string($service) && 0 === strpos($service, '@'))
    {
      return substr($service, 1);
    }
    $definition = new sfServiceDefinition($service['class']);
    if (isset($service['shared']))
    {
      $definition->setShared($service['shared']);
    }
    if (isset($service['constructor']))
    {
      $definition->setConstructor($service['constructor']);
    }
    if (isset($service['file']))
    {
      $definition->setFile($service['file']);
    }
    if (isset($service['arguments']))
    {
      $definition->setArguments($this->resolveServices($service['arguments']));
    }
    if (isset($service['configurator']))
    {
      if (is_string($service['configurator']))
      {
        $definition->setConfigurator($service['configurator']);
      }
      else
      {
        $definition->setConfigurator(array($this->resolveServices($service['configurator'][0]), $service['configurator'][1]));
      }
    }
    if (isset($service['calls']))
    {
      foreach ($service['calls'] as $call)
      {
        $definition->addMethodCall($call[0], $this->resolveServices($call[1]));
      }
    }
    return $definition;
  }
  protected function resolveServices($value)
  {
    if (is_array($value))
    {
      $value = array_map(array($this, 'resolveServices'), $value);
    }
    else if (is_string($value) && 0 === strpos($value, '@'))
    {
      $value = new sfServiceReference(substr($value, 1));
    }
    return $value;
  }
}

abstract class sfWebController extends sfController
{
  public function genUrl($parameters = array(), $absolute = false)
  {
    $route = '';
    $fragment = '';
    if (is_string($parameters))
    {
            if (preg_match('#^[a-z][a-z0-9\+.\-]*\://#i', $parameters))
      {
        return $parameters;
      }
            if (0 === strpos($parameters, '/'))
      {
        return $parameters;
      }
      if ($parameters == '#')
      {
        return $parameters;
      }
            if (false !== ($pos = strpos($parameters, '#')))
      {
        $fragment = substr($parameters, $pos + 1);
        $parameters = substr($parameters, 0, $pos);
      }
      list($route, $parameters) = $this->convertUrlStringToParameters($parameters);
    }
    else if (is_array($parameters))
    {
      if (isset($parameters['sf_route']))
      {
        $route = $parameters['sf_route'];
        unset($parameters['sf_route']);
      }
    }
        $url = $this->context->getRouting()->generate($route, $parameters, $absolute);
    if ($fragment)
    {
      $url .= '#'.$fragment;
    }
    return $url;
  }
  public function convertUrlStringToParameters($url)
  {
    $givenUrl = $url;
    $params = array();
    $queryString = '';
    $route = '';
        if (!$url)
    {
      $url = '/';
    }
        if ($pos = strpos($url, '?'))
    {
      $queryString = substr($url, $pos + 1);
      $url = substr($url, 0, $pos);
    }
        if ($url[0] == '/')
    {
      $url = substr($url, 1);
    }
        if ($url && $url[0] == '@')
    {
      $route = substr($url, 1);
    }
    else if (false !== strpos($url, '/'))
    {
      list($params['module'], $params['action']) = explode('/', $url);
    }
    else if (!$queryString)
    {
      $route = $givenUrl;
    }
    else
    {
      throw new InvalidArgumentException(sprintf('An internal URI must contain a module and an action (module/action) ("%s" given).', $givenUrl));
    }
        if ($queryString)
    {
      $matched = preg_match_all('/
        ([^&=]+)            # key
        =                   # =
        (.*?)               # value
        (?:
          (?=&[^&=]+=) | $  # followed by another key= or the end of the string
        )
      /x', $queryString, $matches, PREG_SET_ORDER | PREG_OFFSET_CAPTURE);
      foreach ($matches as $match)
      {
        $params[urldecode($match[1][0])] = urldecode($match[2][0]);
      }
            if (!$matched)
      {
        throw new sfParseException(sprintf('Unable to parse query string "%s".', $queryString));
      }
    }
    return array($route, $params);
  }
  public function redirect($url, $delay = 0, $statusCode = 302)
  {
    if (empty($url))
    {
      throw new InvalidArgumentException('Cannot redirect to an empty URL.');
    }
    $url = $this->genUrl($url, true);
        $url = str_replace('&amp;', '&', $url);
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Redirect to "%s"', $url))));
    }
    $response = $this->context->getResponse();
    $response->clearHttpHeaders();
    $response->setStatusCode($statusCode);
            if ($statusCode == 201 || ($statusCode >= 300 && $statusCode < 400))
    {
      $response->setHttpHeader('Location', $url);
    }
    $response->setContent(sprintf('<html><head><meta http-equiv="refresh" content="%d;url=%s"/></head></html>', $delay, htmlspecialchars($url, ENT_QUOTES, sfConfig::get('sf_charset'))));
    $response->send();
  }
}

class sfFrontWebController extends sfWebController
{
  public function dispatch()
  {
    try
    {
            sfFilter::$filterCalled = array();
      $request    = $this->context->getRequest();
      $moduleName = $request->getParameter('module');
      $actionName = $request->getParameter('action');
      if (empty($moduleName) || empty($actionName))
      {
        throw new sfError404Exception(sprintf('Empty module and/or action after parsing the URL "%s" (%s/%s).', $request->getPathInfo(), $moduleName, $actionName));
      }
            $this->forward($moduleName, $actionName);
    }
    catch (sfException $e)
    {
      $e->printStackTrace();
    }
    catch (Exception $e)
    {
      sfException::createFromException($e)->printStackTrace();
    }
  }
}

class sfWebRequest extends sfRequest
{
  const
    PORT_HTTP  = 80,
    PORT_HTTPS = 443;
  protected
    $languages              = null,
    $charsets               = null,
    $acceptableContentTypes = null,
    $pathInfoArray          = null,
    $relativeUrlRoot        = null,
    $getParameters          = null,
    $postParameters         = null,
    $requestParameters      = null,
    $formats                = array(),
    $format                 = null,
    $fixedFileArray         = false;
  public function initialize(sfEventDispatcher $dispatcher, $parameters = array(), $attributes = array(), $options = array())
  {
    $options = array_merge(array(
      'path_info_key'   => 'PATH_INFO',
      'path_info_array' => 'SERVER',
      'http_port'       => null,
      'https_port'      => null,
      'default_format'  => null,       'trust_proxy'     => true,     ), $options);
    parent::initialize($dispatcher, $parameters, $attributes, $options);
        $this->getParameters = get_magic_quotes_gpc() ? sfToolkit::stripslashesDeep($_GET) : $_GET;
    $this->parameterHolder->add($this->getParameters);
    $postParameters = $_POST;
    if (isset($_SERVER['REQUEST_METHOD']))
    {
      switch ($_SERVER['REQUEST_METHOD'])
      {
        case 'GET':
          $this->setMethod(self::GET);
          break;
        case 'POST':
          if (isset($postParameters['sf_method']))
          {
            $this->setMethod(strtoupper($postParameters['sf_method']));
            unset($postParameters['sf_method']);
          }
          elseif (isset($this->getParameters['sf_method']))
          {
            $this->setMethod(strtoupper($this->getParameters['sf_method']));
            unset($this->getParameters['sf_method']);
          }
          else
          {
            $this->setMethod(self::POST);
          }
          $this->parameterHolder->remove('sf_method');
          break;
        case 'PUT':
          $this->setMethod(self::PUT);
          if ('application/x-www-form-urlencoded' === $this->getContentType())
          {
            parse_str($this->getContent(), $postParameters);
          }
          break;
        case 'PATCH':
          $this->setMethod(self::PATCH);
          if ('application/x-www-form-urlencoded' === $this->getContentType())
          {
            parse_str($this->getContent(), $postParameters);
          }
          break;
        case 'DELETE':
          $this->setMethod(self::DELETE);
          if ('application/x-www-form-urlencoded' === $this->getContentType())
          {
            parse_str($this->getContent(), $postParameters);
          }
          break;
        case 'HEAD':
          $this->setMethod(self::HEAD);
          break;
        case 'OPTIONS':
          $this->setMethod(self::OPTIONS);
          break;
        default:
          $this->setMethod(self::GET);
      }
    }
    else
    {
            $this->setMethod(self::GET);
    }
    $this->postParameters = get_magic_quotes_gpc() ? sfToolkit::stripslashesDeep($postParameters) : $postParameters;
    $this->parameterHolder->add($this->postParameters);
    if ($formats = $this->getOption('formats'))
    {
      foreach ($formats as $format => $mimeTypes)
      {
        $this->setFormat($format, $mimeTypes);
      }
    }
        $this->requestParameters = $this->parseRequestParameters();
    $this->parameterHolder->add($this->requestParameters);
    $this->fixParameters();
  }
  public function getContentType($trim = true)
  {
    $contentType = $this->getHttpHeader('Content-Type', null);
    if ($trim && false !== $pos = strpos($contentType, ';'))
    {
      $contentType = substr($contentType, 0, $pos);
    }
    return $contentType;
  }
  public function getUri()
  {
    $pathArray = $this->getPathInfoArray();
        if ('HTTP_X_REWRITE_URL' == $this->getOption('path_info_key'))
    {
      $uri = isset($pathArray['HTTP_X_REWRITE_URL']) ? $pathArray['HTTP_X_REWRITE_URL'] : '';
    }
    else
    {
      $uri = isset($pathArray['REQUEST_URI']) ? $pathArray['REQUEST_URI'] : '';
    }
    return $this->isAbsUri() ? $uri : $this->getUriPrefix().$uri;
  }
  public function isAbsUri()
  {
    $pathArray = $this->getPathInfoArray();
    return isset($pathArray['REQUEST_URI']) ? 0 === strpos($pathArray['REQUEST_URI'], 'http') : false;
  }
  public function getUriPrefix()
  {
    $pathArray = $this->getPathInfoArray();
    $secure = $this->isSecure();
    $protocol = $secure ? 'https' : 'http';
    $host = $this->getHost();
    $port = null;
        if (false !== strpos($host, ':'))
    {
      list($host, $port) = explode(':', $host, 2);
    }
    else if ($protocolPort = $this->getOption($protocol.'_port'))
    {
      $port = $protocolPort;
    }
    else if (isset($pathArray['SERVER_PORT']))
    {
      $port = $pathArray['SERVER_PORT'];
    }
            if ($this->isForwardedSecure())
    {
      $port = self::PORT_HTTPS != $this->getOption('https_port') ? $this->getOption('https_port') : null;
    }
    elseif (($secure && self::PORT_HTTPS == $port) || (!$secure && self::PORT_HTTP == $port))
    {
      $port = null;
    }
    return sprintf('%s://%s%s', $protocol, $host, $port ? ':'.$port : '');
  }
  public function getPathInfo()
  {
    $pathInfo = '';
    $pathArray = $this->getPathInfoArray();
        $sf_path_info_key = $this->getOption('path_info_key');
    if (!isset($pathArray[$sf_path_info_key]) || !$pathArray[$sf_path_info_key])
    {
      if (isset($pathArray['REQUEST_URI']))
      {
        $qs = isset($pathArray['QUERY_STRING']) ? $pathArray['QUERY_STRING'] : '';
        $script_name = $this->getScriptName();
        $uri_prefix = $this->isAbsUri() ? $this->getUriPrefix() : '';
        $pathInfo = preg_replace('/^'.preg_quote($uri_prefix, '/').'/','',$pathArray['REQUEST_URI']);
        $pathInfo = preg_replace('/^'.preg_quote($script_name, '/').'/', '', $pathInfo);
        $prefix_name = preg_replace('#/[^/]+$#', '', $script_name);
        $pathInfo = preg_replace('/^'.preg_quote($prefix_name, '/').'/', '', $pathInfo);
        $pathInfo = preg_replace('/\??'.preg_quote($qs, '/').'$/', '', $pathInfo);
      }
    }
    else
    {
      $pathInfo = $pathArray[$sf_path_info_key];
      if ($relativeUrlRoot = $this->getRelativeUrlRoot())
      {
        $pathInfo = preg_replace('/^'.str_replace('/', '\\/', $relativeUrlRoot).'\//', '', $pathInfo);
      }
    }
        if (isset($_SERVER['SERVER_SOFTWARE']) && false !== stripos($_SERVER['SERVER_SOFTWARE'], 'iis') && $pos = stripos($pathInfo, '.php'))
    {
      $pathInfo = substr($pathInfo, $pos + 4);
    }
    if (!$pathInfo)
    {
      $pathInfo = '/';
    }
    return $pathInfo;
  }
  public function getPathInfoPrefix()
  {
    $prefix = $this->getRelativeUrlRoot();
    if (!$this->getOption('no_script_name'))
    {
      $scriptName = $this->getScriptName();
      $prefix = null === $prefix ? $scriptName : $prefix.'/'.basename($scriptName);
    }
    return $prefix;
  }
  public function getGetParameters()
  {
    return $this->getParameters;
  }
  public function getPostParameters()
  {
    return $this->postParameters;
  }
  public function getRequestParameters()
  {
    return $this->requestParameters;
  }
  public function addRequestParameters(array $parameters)
  {
    $this->requestParameters = array_merge($this->requestParameters, $parameters);
    $this->getParameterHolder()->add($parameters);
    $this->fixParameters();
  }
  public function getReferer()
  {
    $pathArray = $this->getPathInfoArray();
    return isset($pathArray['HTTP_REFERER']) ? $pathArray['HTTP_REFERER'] : '';
  }
  public function getHost()
  {
    $pathArray = $this->getPathInfoArray();
    if ($this->getOption('trust_proxy') && isset($pathArray['HTTP_X_FORWARDED_HOST']))
    {
      $elements = explode(',', $pathArray['HTTP_X_FORWARDED_HOST']);
      return trim($elements[count($elements) - 1]);
    }
    return isset($pathArray['HTTP_HOST']) ? $pathArray['HTTP_HOST'] : '';
  }
  public function getScriptName()
  {
    $pathArray = $this->getPathInfoArray();
    return isset($pathArray['SCRIPT_NAME']) ? $pathArray['SCRIPT_NAME'] : (isset($pathArray['ORIG_SCRIPT_NAME']) ? $pathArray['ORIG_SCRIPT_NAME'] : '');
  }
  public function isMethod($method)
  {
    return strtoupper($method) == $this->getMethod();
  }
  public function getPreferredCulture(array $cultures = null)
  {
    $preferredCultures = $this->getLanguages();
    if (null === $cultures)
    {
      return isset($preferredCultures[0]) ? $preferredCultures[0] : null;
    }
    if (!$preferredCultures)
    {
      return $cultures[0];
    }
    $preferredCultures = array_values(array_intersect($preferredCultures, $cultures));
    return isset($preferredCultures[0]) ? $preferredCultures[0] : $cultures[0];
  }
  public function getLanguages()
  {
    if ($this->languages)
    {
      return $this->languages;
    }
    if (!isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
    {
      return array();
    }
    $languages = $this->splitHttpAcceptHeader($_SERVER['HTTP_ACCEPT_LANGUAGE']);
    foreach ($languages as $lang)
    {
      if (false !== strpos($lang, '-'))
      {
        $codes = explode('-', $lang);
        if ($codes[0] == 'i')
        {
                                        if (count($codes) > 1)
          {
            $lang = $codes[1];
          }
        }
        else
        {
          for ($i = 0, $max = count($codes); $i < $max; $i++)
          {
            if ($i == 0)
            {
              $lang = strtolower($codes[0]);
            }
            else
            {
              $lang .= '_'.strtoupper($codes[$i]);
            }
          }
        }
      }
      $this->languages[] = $lang;
    }
    return $this->languages;
  }
  public function getCharsets()
  {
    if ($this->charsets)
    {
      return $this->charsets;
    }
    if (!isset($_SERVER['HTTP_ACCEPT_CHARSET']))
    {
      return array();
    }
    $this->charsets = $this->splitHttpAcceptHeader($_SERVER['HTTP_ACCEPT_CHARSET']);
    return $this->charsets;
  }
  public function getAcceptableContentTypes()
  {
    if ($this->acceptableContentTypes)
    {
      return $this->acceptableContentTypes;
    }
    if (!isset($_SERVER['HTTP_ACCEPT']))
    {
      return array();
    }
    $this->acceptableContentTypes = $this->splitHttpAcceptHeader($_SERVER['HTTP_ACCEPT']);
    return $this->acceptableContentTypes;
  }
  public function isXmlHttpRequest()
  {
    return ($this->getHttpHeader('X_REQUESTED_WITH') == 'XMLHttpRequest');
  }
  public function getHttpHeader($name, $prefix = 'http')
  {
    if ($prefix)
    {
      $prefix = strtoupper($prefix).'_';
    }
    $name = $prefix.strtoupper(str_replace('-', '_', $name));
    $pathArray = $this->getPathInfoArray();
    return isset($pathArray[$name]) ? sfToolkit::stripslashesDeep($pathArray[$name]) : null;
  }
  public function getCookie($name, $defaultValue = null)
  {
    $retval = $defaultValue;
    if (isset($_COOKIE[$name]))
    {
      $retval = get_magic_quotes_gpc() ? sfToolkit::stripslashesDeep($_COOKIE[$name]) : $_COOKIE[$name];
    }
    return $retval;
  }
  public function isSecure()
  {
    $pathArray = $this->getPathInfoArray();
    return
      (isset($pathArray['HTTPS']) && (('on' == strtolower($pathArray['HTTPS']) || 1 == $pathArray['HTTPS'])))
      ||
      ($this->getOption('trust_proxy') && isset($pathArray['HTTP_SSL_HTTPS']) && (('on' == strtolower($pathArray['HTTP_SSL_HTTPS']) || 1 == $pathArray['HTTP_SSL_HTTPS'])))
      ||
      ($this->getOption('trust_proxy') && $this->isForwardedSecure())
    ;
  }
  protected function isForwardedSecure()
  {
    $pathArray = $this->getPathInfoArray();
    return isset($pathArray['HTTP_X_FORWARDED_PROTO']) && 'https' == strtolower($pathArray['HTTP_X_FORWARDED_PROTO']);
  }
  public function getRelativeUrlRoot()
  {
    if (null === $this->relativeUrlRoot)
    {
      if (!($this->relativeUrlRoot = $this->getOption('relative_url_root')))
      {
        $this->relativeUrlRoot = preg_replace('#/[^/]+\.php5?$#', '', $this->getScriptName());
      }
    }
    return $this->relativeUrlRoot;
  }
  public function setRelativeUrlRoot($value)
  {
    $this->relativeUrlRoot = $value;
  }
  public function splitHttpAcceptHeader($header)
  {
    $values = array();
    $groups = array();
    foreach (array_filter(explode(',', $header)) as $value)
    {
            if ($pos = strpos($value, ';'))
      {
        $q     = trim(substr($value, strpos($value, '=') + 1));
        $value = substr($value, 0, $pos);
      }
      else
      {
        $q = 1;
      }
      $groups[$q][] = $value;
    }
    krsort($groups);
    foreach ($groups as $q => $items) {
      if (0 < $q) {
        foreach ($items as $value) {
          $values[] = trim($value);
        }
      }
    }
    return $values;
  }
  public function getPathInfoArray()
  {
    if (!$this->pathInfoArray)
    {
            switch ($this->getOption('path_info_array'))
      {
        case 'SERVER':
          $this->pathInfoArray =& $_SERVER;
          break;
        case 'ENV':
        default:
          $this->pathInfoArray =& $_ENV;
      }
    }
    return $this->pathInfoArray;
  }
  public function getMimeType($format)
  {
    return isset($this->formats[$format]) ? $this->formats[$format][0] : null;
  }
  public function getFormat($mimeType)
  {
    foreach ($this->formats as $format => $mimeTypes)
    {
      if (in_array($mimeType, $mimeTypes))
      {
        return $format;
      }
    }
    return null;
  }
  public function setFormat($format, $mimeTypes)
  {
    $this->formats[$format] = is_array($mimeTypes) ? $mimeTypes : array($mimeTypes);
  }
  public function setRequestFormat($format)
  {
    $this->format = $format;
  }
  public function getRequestFormat()
  {
    if (null === $this->format)
    {
      $this->setRequestFormat($this->getParameter('sf_format', $this->getOption('default_format')));
    }
    return $this->format;
  }
  public function getFiles($key = null)
  {
    if (false === $this->fixedFileArray)
    {
      $this->fixedFileArray = self::convertFileInformation($_FILES);
    }
    return null === $key ? $this->fixedFileArray : (isset($this->fixedFileArray[$key]) ? $this->fixedFileArray[$key] : array());
  }
  static public function convertFileInformation(array $taintedFiles)
  {
    $files = array();
    foreach ($taintedFiles as $key => $data)
    {
      $files[$key] = self::fixPhpFilesArray($data);
    }
    return $files;
  }
  static protected function fixPhpFilesArray(array $data)
  {
    $fileKeys = array('error', 'name', 'size', 'tmp_name', 'type');
    $keys = array_keys($data);
    sort($keys);
    if ($fileKeys != $keys || !isset($data['name']) || !is_array($data['name']))
    {
      return $data;
    }
    $files = $data;
    foreach ($fileKeys as $k)
    {
      unset($files[$k]);
    }
    foreach (array_keys($data['name']) as $key)
    {
      $files[$key] = self::fixPhpFilesArray(array(
        'error'    => $data['error'][$key],
        'name'     => $data['name'][$key],
        'type'     => $data['type'][$key],
        'tmp_name' => $data['tmp_name'][$key],
        'size'     => $data['size'][$key],
      ));
    }
    return $files;
  }
  public function getGetParameter($name, $default = null)
  {
    if (isset($this->getParameters[$name]))
    {
      return $this->getParameters[$name];
    }
    else
    {
      return sfToolkit::getArrayValueForPath($this->getParameters, $name, $default);
    }
  }
  public function getPostParameter($name, $default = null)
  {
    if (isset($this->postParameters[$name]))
    {
      return $this->postParameters[$name];
    }
    else
    {
      return sfToolkit::getArrayValueForPath($this->postParameters, $name, $default);
    }
  }
  public function getUrlParameter($name, $default = null)
  {
    if (isset($this->requestParameters[$name]))
    {
      return $this->requestParameters[$name];
    }
    else
    {
      return sfToolkit::getArrayValueForPath($this->requestParameters, $name, $default);
    }
  }
  public function getRemoteAddress()
  {
    $pathInfo = $this->getPathInfoArray();
    return $pathInfo['REMOTE_ADDR'];
  }
  public function getForwardedFor()
  {
    $pathInfo = $this->getPathInfoArray();
    if (empty($pathInfo['HTTP_X_FORWARDED_FOR']))
    {
      return null;
    }
    return explode(', ', $pathInfo['HTTP_X_FORWARDED_FOR']);
  }
  public function getClientIp($proxy = true)
  {
    if ($proxy)
    {
      $pathInfo = $this->getPathInfoArray();
      if (isset($pathInfo["HTTP_CLIENT_IP"]) && ($ip = $pathInfo["HTTP_CLIENT_IP"]))
      {
        return $ip;
      }
      if ($this->getOption('trust_proxy') && ($ip = $this->getForwardedFor()))
      {
        return isset($ip[0]) ? trim($ip[0]) : '';
      }
    }
    return $this->getRemoteAddress();
  }
  public function checkCSRFProtection()
  {
    $form = new BaseForm();
    $form->bind($form->isCSRFProtected() ? array($form->getCSRFFieldName() => $this->getParameter($form->getCSRFFieldName())) : array());
    if (!$form->isValid())
    {
      throw $form->getErrorSchema();
    }
  }
  protected function parseRequestParameters()
  {
    return $this->dispatcher->filter(new sfEvent($this, 'request.filter_parameters', $this->getRequestContext()), array())->getReturnValue();
  }
  public function getRequestContext()
  {
    return array(
      'path_info'   => $this->getPathInfo(),
      'prefix'      => $this->getPathInfoPrefix(),
      'method'      => $this->getMethod(),
      'format'      => $this->getRequestFormat(),
      'host'        => $this->getHost(),
      'is_secure'   => $this->isSecure(),
      'request_uri' => $this->getUri(),
    );
  }
  protected function fixParameters()
  {
    foreach ($this->parameterHolder->getAll() as $key => $value)
    {
      if (0 === stripos($key, '_sf_'))
      {
        $this->parameterHolder->remove($key);
        $this->setAttribute(substr($key, 1), $value);
      }
    }
  }
}

class sfPatternRouting extends sfRouting
{
  protected $currentRouteName = null;
  protected $currentInternalUri = array();
  protected $routes = array();
  protected $cacheData = array();
  protected $cacheChanged = false;
  public function initialize(sfEventDispatcher $dispatcher, sfCache $cache = null, $options = array())
  {
    $options = array_merge(array(
      'variable_prefixes'                => array(':'),
      'segment_separators'               => array('/', '.'),
      'variable_regex'                   => '[\w\d_]+',
      'load_configuration'               => false,
      'suffix'                           => '',
      'generate_shortest_url'            => true,
      'extra_parameters_as_query_string' => true,
      'lookup_cache_dedicated_keys'      => false,
    ), $options);
        if ('.' == $options['suffix'])
    {
      $options['suffix'] = '';
    }
    parent::initialize($dispatcher, $cache, $options);
    if (null !== $this->cache && !$options['lookup_cache_dedicated_keys'] && $cacheData = $this->cache->get('symfony.routing.data'))
    {
      $this->cacheData = unserialize($cacheData);
    }
  }
  public function loadConfiguration()
  {
    if ($this->options['load_configuration'] && $config = $this->getConfigFileName())
    {
      include($config);
    }
    parent::loadConfiguration();
  }
  public function setDefaultParameter($key, $value)
  {
    parent::setDefaultParameter($key, $value);
    foreach ($this->routes as $route)
    {
      if (is_object($route))
      {
        $route->setDefaultParameters($this->defaultParameters);
      }
    }
  }
  public function setDefaultParameters($parameters)
  {
    parent::setDefaultParameters($parameters);
    foreach ($this->routes as $route)
    {
      if (is_object($route))
      {
        $route->setDefaultParameters($this->defaultParameters);
      }
    }
  }
  protected function getConfigFileName()
  {
    return sfContext::getInstance()->getConfigCache()->checkConfig('config/routing.yml', true);
  }
  public function getCurrentInternalUri($withRouteName = false)
  {
    return null === $this->currentRouteName ? null : $this->currentInternalUri[$withRouteName ? 0 : 1];
  }
  public function getCurrentRouteName()
  {
    return $this->currentRouteName;
  }
  public function getRoutes()
  {
    return $this->routes;
  }
  public function getRoute($name)
  {
    if (!array_key_exists($name, $this->routes))
    {
      throw new sfException(sprintf('Route "%s" is not defined.', $name));
    }
    $route = $this->routes[$name];
    if (is_string($route))
    {
      $this->routes[$name] = $route = unserialize($route);
      $route->setDefaultParameters($this->defaultParameters);
    }
    return $route;
  }
  public function setRoutes($routes)
  {
    foreach ($routes as $name => $route)
    {
      $this->connect($name, $route);
    }
  }
  public function hasRoutes()
  {
    return count($this->routes) ? true : false;
  }
  public function clearRoutes()
  {
    if ($this->options['logging'])
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array('Clear all current routes')));
    }
    $this->routes = array();
  }
  public function hasRouteName($name)
  {
    return array_key_exists($name, $this->routes);
  }
  public function prependRoute($name, $route)
  {
    $routes = $this->routes;
    $this->routes = array();
    $this->connect($name, $route);
    $this->routes = array_merge($this->routes, $routes);
  }
  public function appendRoute($name, $route)
  {
    return $this->connect($name, $route);
  }
  public function insertRouteBefore($pivot, $name, $route)
  {
    if (!isset($this->routes[$pivot]))
    {
      throw new sfConfigurationException(sprintf('Unable to insert route "%s" before inexistent route "%s".', $name, $pivot));
    }
    $routes = $this->routes;
    $this->routes = array();
    $newroutes = array();
    foreach ($routes as $key => $value)
    {
      if ($key == $pivot)
      {
        $this->connect($name, $route);
        $newroutes = array_merge($newroutes, $this->routes);
      }
      $newroutes[$key] = $value;
    }
    $this->routes = $newroutes;
  }
  public function connect($name, $route)
  {
    $routes = $route instanceof sfRouteCollection ? $route : array($name => $route);
    foreach (self::flattenRoutes($routes) as $name => $route)
    {
      $this->routes[$name] = $route;
      $this->configureRoute($route);
      if ($this->options['logging'])
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Connect %s "%s" (%s)', get_class($route), $name, $route->getPattern()))));
      }
    }
  }
  public function configureRoute(sfRoute $route)
  {
    $route->setDefaultParameters($this->defaultParameters);
    $route->setDefaultOptions($this->options);
  }
  public function generate($name, $params = array(), $absolute = false)
  {
        if (null !== $this->cache)
    {
      $cacheKey = $this->getGenerateCacheKey($name, (array) $params);
      if ($this->options['lookup_cache_dedicated_keys'] && $url = $this->cache->get($cacheKey))
      {
        return $this->fixGeneratedUrl($url, $absolute);
      }
      elseif (isset($this->cacheData[$cacheKey]))
      {
        return $this->fixGeneratedUrl($this->cacheData[$cacheKey], $absolute);
      }
    }
    if ($name)
    {
      $route = $this->getRoute($name);
    }
    else
    {
            if (false === $route = $this->getRouteThatMatchesParameters($params))
      {
        throw new sfConfigurationException(sprintf('Unable to find a matching route to generate url for params "%s".', is_object($params) ? 'Object('.get_class($params).')' : str_replace("\n", '', var_export($params, true))));
      }
    }
    $url = $route->generate($params, $this->options['context'], $absolute);
        if (null !== $this->cache)
    {
      if ($this->options['lookup_cache_dedicated_keys'])
      {
        $this->cache->set($cacheKey, $url);
      }
      else
      {
        $this->cacheChanged = true;
        $this->cacheData[$cacheKey] = $url;
      }
    }
    return $this->fixGeneratedUrl($url, $absolute);
  }
  protected function getGenerateCacheKey($name, $params)
  {
    return 'generate_'.$name.'_'.md5(serialize(array_merge($this->defaultParameters, $params))).'_'.md5(serialize($this->options['context']));
  }
  public function parse($url)
  {
    if (false === $info = $this->findRoute($url))
    {
      $this->currentRouteName = null;
      $this->currentInternalUri = array();
      return false;
    }
    if ($this->options['logging'])
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Match route "%s" (%s) for %s with parameters %s', $info['name'], $info['pattern'], $url, str_replace("\n", '', var_export($info['parameters'], true))))));
    }
        $this->updateCurrentInternalUri($info['name'], $info['parameters']);
    $route = $this->getRoute($info['name']);
    $route->bind($this->options['context'], $info['parameters']);
    $info['parameters']['_sf_route'] = $route;
    return $info['parameters'];
  }
  protected function updateCurrentInternalUri($name, array $parameters)
  {
        $this->currentRouteName = $name;
    $internalUri = array('@'.$this->currentRouteName, $parameters['module'].'/'.$parameters['action']);
    unset($parameters['module'], $parameters['action']);
    $params = array();
    foreach ($parameters as $key => $value)
    {
      $params[] = $key.'='.$value;
    }
        sort($params);
    $params = $params ? '?'.implode('&', $params) : '';
    $this->currentInternalUri = array($internalUri[0].$params, $internalUri[1].$params);
  }
  public function findRoute($url)
  {
    $url = $this->normalizeUrl($url);
        if (null !== $this->cache)
    {
      $cacheKey = $this->getParseCacheKey($url);
      if ($this->options['lookup_cache_dedicated_keys'] && $info = $this->cache->get($cacheKey))
      {
        return unserialize($info);
      }
      elseif (isset($this->cacheData[$cacheKey]))
      {
        return $this->cacheData[$cacheKey];
      }
    }
    $info = $this->getRouteThatMatchesUrl($url);
        if (null !== $this->cache)
    {
      if ($this->options['lookup_cache_dedicated_keys'])
      {
        $this->cache->set($cacheKey, serialize($info));
      }
      else
      {
        $this->cacheChanged = true;
        $this->cacheData[$cacheKey] = $info;
      }
    }
    return $info;
  }
  protected function getParseCacheKey($url)
  {
    return 'parse_'.$url.'_'.md5(serialize($this->options['context']));
  }
  static public function flattenRoutes($routes)
  {
    $flattenRoutes = array();
    foreach ($routes as $name => $route)
    {
      if ($route instanceof sfRouteCollection)
      {
        $flattenRoutes = array_merge($flattenRoutes, self::flattenRoutes($route));
      }
      else
      {
        $flattenRoutes[$name] = $route;
      }
    }
    return $flattenRoutes;
  }
  protected function getRouteThatMatchesUrl($url)
  {
    foreach ($this->routes as $name => $route)
    {
      $route = $this->getRoute($name);
      if (false === $parameters = $route->matchesUrl($url, $this->options['context']))
      {
        continue;
      }
      return array('name' => $name, 'pattern' => $route->getPattern(), 'parameters' => $parameters);
    }
    return false;
  }
  protected function getRouteThatMatchesParameters($parameters)
  {
    foreach ($this->routes as $name => $route)
    {
      $route = $this->getRoute($name);
      if ($route->matchesParameters($parameters, $this->options['context']))
      {
        return $route;
      }
    }
    return false;
  }
  protected function normalizeUrl($url)
  {
        if ('/' != substr($url, 0, 1))
    {
      $url = '/'.$url;
    }
        if (false !== $pos = strpos($url, '?'))
    {
      $url = substr($url, 0, $pos);
    }
        $url = preg_replace('#/+#', '/', $url);
    return $url;
  }
  public function shutdown()
  {
    if (null !== $this->cache && $this->cacheChanged)
    {
      $this->cacheChanged = false;
      $this->cache->set('symfony.routing.data', serialize($this->cacheData));
    }
  }
}

class sfWebResponse extends sfResponse
{
  const
    FIRST  = 'first',
    MIDDLE = '',
    LAST   = 'last',
    ALL    = 'ALL',
    RAW    = 'RAW';
  protected
    $cookies     = array(),
    $statusCode  = 200,
    $statusText  = 'OK',
    $headerOnly  = false,
    $headers     = array(),
    $metas       = array(),
    $httpMetas   = array(),
    $positions   = array('first', '', 'last'),
    $stylesheets = array(),
    $javascripts = array(),
    $slots       = array();
  static protected $statusTexts = array(
    '100' => 'Continue',
    '101' => 'Switching Protocols',
    '200' => 'OK',
    '201' => 'Created',
    '202' => 'Accepted',
    '203' => 'Non-Authoritative Information',
    '204' => 'No Content',
    '205' => 'Reset Content',
    '206' => 'Partial Content',
    '300' => 'Multiple Choices',
    '301' => 'Moved Permanently',
    '302' => 'Found',
    '303' => 'See Other',
    '304' => 'Not Modified',
    '305' => 'Use Proxy',
    '306' => '(Unused)',
    '307' => 'Temporary Redirect',
    '400' => 'Bad Request',
    '401' => 'Unauthorized',
    '402' => 'Payment Required',
    '403' => 'Forbidden',
    '404' => 'Not Found',
    '405' => 'Method Not Allowed',
    '406' => 'Not Acceptable',
    '407' => 'Proxy Authentication Required',
    '408' => 'Request Timeout',
    '409' => 'Conflict',
    '410' => 'Gone',
    '411' => 'Length Required',
    '412' => 'Precondition Failed',
    '413' => 'Request Entity Too Large',
    '414' => 'Request-URI Too Long',
    '415' => 'Unsupported Media Type',
    '416' => 'Requested Range Not Satisfiable',
    '417' => 'Expectation Failed',
    '500' => 'Internal Server Error',
    '501' => 'Not Implemented',
    '502' => 'Bad Gateway',
    '503' => 'Service Unavailable',
    '504' => 'Gateway Timeout',
    '505' => 'HTTP Version Not Supported',
  );
  public function initialize(sfEventDispatcher $dispatcher, $options = array())
  {
    parent::initialize($dispatcher, $options);
    $this->javascripts = array_combine($this->positions, array_fill(0, count($this->positions), array()));
    $this->stylesheets = array_combine($this->positions, array_fill(0, count($this->positions), array()));
    if (!isset($this->options['charset']))
    {
      $this->options['charset'] = 'utf-8';
    }
    if (!isset($this->options['send_http_headers']))
    {
      $this->options['send_http_headers'] = true;
    }
    if (!isset($this->options['http_protocol']))
    {
      $this->options['http_protocol'] = 'HTTP/1.0';
    }
    $this->options['content_type'] = $this->fixContentType(isset($this->options['content_type']) ? $this->options['content_type'] : 'text/html');
  }
  public function setHeaderOnly($value = true)
  {
    $this->headerOnly = (boolean) $value;
  }
  public function isHeaderOnly()
  {
    return $this->headerOnly;
  }
  public function setCookie($name, $value, $expire = null, $path = '/', $domain = '', $secure = false, $httpOnly = false)
  {
    if ($expire !== null)
    {
      if (is_numeric($expire))
      {
        $expire = (int) $expire;
      }
      else
      {
        $expire = strtotime($expire);
        if ($expire === false || $expire == -1)
        {
          throw new sfException('Your expire parameter is not valid.');
        }
      }
    }
    $this->cookies[$name] = array(
      'name'     => $name,
      'value'    => $value,
      'expire'   => $expire,
      'path'     => $path,
      'domain'   => $domain,
      'secure'   => $secure ? true : false,
      'httpOnly' => $httpOnly,
    );
  }
  public function setStatusCode($code, $name = null)
  {
    $this->statusCode = $code;
    $this->statusText = null !== $name ? $name : self::$statusTexts[$code];
  }
  public function getStatusText()
  {
    return $this->statusText;
  }
  public function getStatusCode()
  {
    return $this->statusCode;
  }
  public function setHttpHeader($name, $value, $replace = true)
  {
    $name = $this->normalizeHeaderName($name);
    if (null === $value)
    {
      unset($this->headers[$name]);
      return;
    }
    if ('Content-Type' == $name)
    {
      if ($replace || !$this->getHttpHeader('Content-Type', null))
      {
        $this->setContentType($value);
      }
      return;
    }
    if (!$replace)
    {
      $current = isset($this->headers[$name]) ? $this->headers[$name] : '';
      $value = ($current ? $current.', ' : '').$value;
    }
    $this->headers[$name] = $value;
  }
  public function getHttpHeader($name, $default = null)
  {
    $name = $this->normalizeHeaderName($name);
    return isset($this->headers[$name]) ? $this->headers[$name] : $default;
  }
  public function hasHttpHeader($name)
  {
    return array_key_exists($this->normalizeHeaderName($name), $this->headers);
  }
  public function setContentType($value)
  {
    $this->headers['Content-Type'] = $this->fixContentType($value);
  }
  public function getCharset()
  {
    return $this->options['charset'];
  }
  public function getContentType()
  {
    return $this->getHttpHeader('Content-Type', $this->options['content_type']);
  }
  public function sendHttpHeaders()
  {
    if (!$this->options['send_http_headers'])
    {
      return;
    }
        $status = $this->options['http_protocol'].' '.$this->statusCode.' '.$this->statusText;
    header($status);
    if (substr(php_sapi_name(), 0, 3) == 'cgi')
    {
                  unset($this->headers['Status']);
    }
    if ($this->options['logging'])
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Send status "%s"', $status))));
    }
        if (!$this->getHttpHeader('Content-Type'))
    {
      $this->setContentType($this->options['content_type']);
    }
    foreach ($this->headers as $name => $value)
    {
      header($name.': '.$value);
      if ($value != '' && $this->options['logging'])
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Send header "%s: %s"', $name, $value))));
      }
    }
        foreach ($this->cookies as $cookie)
    {
      setrawcookie($cookie['name'], $cookie['value'], $cookie['expire'], $cookie['path'], $cookie['domain'], $cookie['secure'], $cookie['httpOnly']);
      if ($this->options['logging'])
      {
        $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Send cookie "%s": "%s"', $cookie['name'], $cookie['value']))));
      }
    }
        $this->options['send_http_headers'] = false;
  }
  public function sendContent()
  {
    if (!$this->headerOnly)
    {
      parent::sendContent();
    }
  }
  public function send()
  {
    $this->sendHttpHeaders();
    $this->sendContent();
    if (function_exists('fastcgi_finish_request'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'response.fastcgi_finish_request'));
      fastcgi_finish_request();
    }
  }
  protected function normalizeHeaderName($name)
  {
    return strtr(ucwords(strtr(strtolower($name), array('_' => ' ', '-' => ' '))), array(' ' => '-'));
  }
  static public function getDate($timestamp, $type = 'rfc1123')
  {
    $type = strtolower($type);
    if ($type == 'rfc1123')
    {
      return substr(gmdate('r', $timestamp), 0, -5).'GMT';
    }
    else if ($type == 'rfc1036')
    {
      return gmdate('l, d-M-y H:i:s ', $timestamp).'GMT';
    }
    else if ($type == 'asctime')
    {
      return gmdate('D M j H:i:s', $timestamp);
    }
    else
    {
      throw new InvalidArgumentException('The second getDate() method parameter must be one of: rfc1123, rfc1036 or asctime.');
    }
  }
  public function addVaryHttpHeader($header)
  {
    $vary = $this->getHttpHeader('Vary');
    $currentHeaders = array();
    if ($vary)
    {
      $currentHeaders = preg_split('/\s*,\s*/', $vary);
    }
    $header = $this->normalizeHeaderName($header);
    if (!in_array($header, $currentHeaders))
    {
      $currentHeaders[] = $header;
      $this->setHttpHeader('Vary', implode(', ', $currentHeaders));
    }
  }
  public function addCacheControlHttpHeader($name, $value = null)
  {
    $cacheControl = $this->getHttpHeader('Cache-Control');
    $currentHeaders = array();
    if ($cacheControl)
    {
      foreach (preg_split('/\s*,\s*/', $cacheControl) as $tmp)
      {
        $tmp = explode('=', $tmp);
        $currentHeaders[$tmp[0]] = isset($tmp[1]) ? $tmp[1] : null;
      }
    }
    $currentHeaders[str_replace('_', '-', strtolower($name))] = $value;
    $headers = array();
    foreach ($currentHeaders as $key => $value)
    {
      $headers[] = $key.(null !== $value ? '='.$value : '');
    }
    $this->setHttpHeader('Cache-Control', implode(', ', $headers));
  }
  public function getHttpMetas()
  {
    return $this->httpMetas;
  }
  public function addHttpMeta($key, $value, $replace = true)
  {
    $key = $this->normalizeHeaderName($key);
        $this->setHttpHeader($key, $value, $replace);
    if (null === $value)
    {
      unset($this->httpMetas[$key]);
      return;
    }
    if ('Content-Type' == $key)
    {
      $value = $this->getContentType();
    }
    elseif (!$replace)
    {
      $current = isset($this->httpMetas[$key]) ? $this->httpMetas[$key] : '';
      $value = ($current ? $current.', ' : '').$value;
    }
    $this->httpMetas[$key] = $value;
  }
  public function getMetas()
  {
    return $this->metas;
  }
  public function addMeta($key, $value, $replace = true, $escape = true)
  {
    $key = strtolower($key);
    if (null === $value)
    {
      unset($this->metas[$key]);
      return;
    }
            if ($escape)
    {
      $value = htmlspecialchars($value, ENT_QUOTES, $this->options['charset']);
    }
    $current = isset($this->metas[$key]) ? $this->metas[$key] : null;
    if ($replace || !$current)
    {
      $this->metas[$key] = $value;
    }
  }
  public function getTitle()
  {
    return isset($this->metas['title']) ? $this->metas['title'] : '';
  }
  public function prependTitle($title, $separator = ' - ', $escape = true)
  {
    if (!isset($this->metas['title']))
    {
      $this->setTitle($title);
      return;
    }
            if ($escape)
    {
      $title = htmlspecialchars($title, ENT_QUOTES, $this->options['charset']);
    }
    $this->metas['title'] = $title.$separator.$this->metas['title'];
  }
  public function setTitle($title, $escape = true)
  {
    $this->addMeta('title', $title, true, $escape);
  }
  public function getPositions()
  {
    return $this->positions;
  }
  public function getStylesheets($position = self::ALL)
  {
    if (self::ALL === $position)
    {
      $stylesheets = array();
      foreach ($this->getPositions() as $position)
      {
        foreach ($this->stylesheets[$position] as $file => $options)
        {
          $stylesheets[$file] = $options;
        }
      }
      return $stylesheets;
    }
    else if (self::RAW === $position)
    {
      return $this->stylesheets;
    }
    $this->validatePosition($position);
    return $this->stylesheets[$position];
  }
  public function addStylesheet($file, $position = '', $options = array())
  {
    $this->validatePosition($position);
    $this->stylesheets[$position][$file] = $options;
  }
  public function removeStylesheet($file)
  {
    foreach ($this->getPositions() as $position)
    {
      unset($this->stylesheets[$position][$file]);
    }
  }
  public function clearStylesheets()
  {
    foreach (array_keys($this->getStylesheets()) as $file)
    {
      $this->removeStylesheet($file);
    }
  }
  public function getJavascripts($position = self::ALL)
  {
    if (self::ALL === $position)
    {
      $javascripts = array();
      foreach ($this->getPositions() as $position)
      {
        foreach ($this->javascripts[$position] as $file => $options)
        {
          $javascripts[$file] = $options;
        }
      }
      return $javascripts;
    }
    else if (self::RAW === $position)
    {
      return $this->javascripts;
    }
    $this->validatePosition($position);
    return $this->javascripts[$position];
  }
  public function addJavascript($file, $position = '', $options = array())
  {
    $this->validatePosition($position);
    $this->javascripts[$position][$file] = $options;
  }
  public function removeJavascript($file)
  {
    foreach ($this->getPositions() as $position)
    {
      unset($this->javascripts[$position][$file]);
    }
  }
  public function clearJavascripts()
  {
    foreach (array_keys($this->getJavascripts()) as $file)
    {
      $this->removeJavascript($file);
    }
  }
  public function getSlots()
  {
    return $this->slots;
  }
  public function setSlot($name, $content)
  {
    $this->slots[$name] = $content;
  }
  public function getCookies()
  {
    return $this->cookies;
  }
  public function getHttpHeaders()
  {
    return $this->headers;
  }
  public function clearHttpHeaders()
  {
    $this->headers = array();
  }
  public function copyProperties(sfWebResponse $response)
  {
    $this->options     = $response->getOptions();
    $this->headers     = $response->getHttpHeaders();
    $this->metas       = $response->getMetas();
    $this->httpMetas   = $response->getHttpMetas();
    $this->stylesheets = $response->getStylesheets(self::RAW);
    $this->javascripts = $response->getJavascripts(self::RAW);
    $this->slots       = $response->getSlots();
            $this->options['http_protocol'] = isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0';
  }
  public function merge(sfWebResponse $response)
  {
    foreach ($this->getPositions() as $position)
    {
      $this->javascripts[$position] = array_merge($this->getJavascripts($position), $response->getJavascripts($position));
      $this->stylesheets[$position] = array_merge($this->getStylesheets($position), $response->getStylesheets($position));
    }
    $this->slots = array_merge($this->getSlots(), $response->getSlots());
  }
  public function serialize()
  {
    return serialize(array($this->content, $this->statusCode, $this->statusText, $this->options, $this->headerOnly, $this->headers, $this->metas, $this->httpMetas, $this->stylesheets, $this->javascripts, $this->slots));
  }
  public function unserialize($serialized)
  {
    list($this->content, $this->statusCode, $this->statusText, $this->options, $this->headerOnly, $this->headers, $this->metas, $this->httpMetas, $this->stylesheets, $this->javascripts, $this->slots) = unserialize($serialized);
  }
  protected function validatePosition($position)
  {
    if (!in_array($position, $this->positions, true))
    {
      throw new InvalidArgumentException(sprintf('The position "%s" does not exist (available positions: %s).', $position, implode(', ', $this->positions)));
    }
  }
  protected function fixContentType($contentType)
  {
        if (false === stripos($contentType, 'charset') && (0 === stripos($contentType, 'text/') || strlen($contentType) - 3 === strripos($contentType, 'xml')))
    {
      $contentType .= '; charset='.$this->options['charset'];
    }
        if (preg_match('/charset\s*=\s*(.+)\s*$/', $contentType, $match))
    {
      $this->options['charset'] = $match[1];
    }
    return $contentType;
  }
}

class sfSessionStorage extends sfStorage
{
  static protected
    $sessionIdRegenerated = false,
    $sessionStarted       = false;
  public function initialize($options = null)
  {
    $cookieDefaults = session_get_cookie_params();
    $options = array_merge(array(
      'session_name'            => 'symfony',
      'session_id'              => null,
      'auto_start'              => true,
      'session_cookie_lifetime' => $cookieDefaults['lifetime'],
      'session_cookie_path'     => $cookieDefaults['path'],
      'session_cookie_domain'   => $cookieDefaults['domain'],
      'session_cookie_secure'   => $cookieDefaults['secure'],
      'session_cookie_httponly' => isset($cookieDefaults['httponly']) ? $cookieDefaults['httponly'] : false,
      'session_cache_limiter'   => null,
    ), $options);
        parent::initialize($options);
        $sessionName = $this->options['session_name'];
    session_name($sessionName);
    if (!(boolean) ini_get('session.use_cookies') && $sessionId = $this->options['session_id'])
    {
      session_id($sessionId);
    }
    $lifetime = $this->options['session_cookie_lifetime'];
    $path     = $this->options['session_cookie_path'];
    $domain   = $this->options['session_cookie_domain'];
    $secure   = $this->options['session_cookie_secure'];
    $httpOnly = $this->options['session_cookie_httponly'];
    session_set_cookie_params($lifetime, $path, $domain, $secure, $httpOnly);
    if (null !== $this->options['session_cache_limiter'])
    {
      session_cache_limiter($this->options['session_cache_limiter']);
    }
    if ($this->options['auto_start'] && !self::$sessionStarted)
    {
      session_start();
      self::$sessionStarted = true;
    }
  }
  public function read($key)
  {
    $retval = null;
    if (isset($_SESSION[$key]))
    {
      $retval = $_SESSION[$key];
    }
    return $retval;
  }
  public function remove($key)
  {
    $retval = null;
    if (isset($_SESSION[$key]))
    {
      $retval = $_SESSION[$key];
      unset($_SESSION[$key]);
    }
    return $retval;
  }
  public function write($key, $data)
  {
    $_SESSION[$key] = $data;
  }
  public function regenerate($destroy = false)
  {
    if (self::$sessionIdRegenerated)
    {
      return;
    }
        session_regenerate_id($destroy);
    self::$sessionIdRegenerated = true;
  }
  public function shutdown()
  {
        session_write_close();
  }
}

class sfPHPView extends sfView
{
  public function execute()
  {
  }
  protected function loadCoreAndStandardHelpers()
  {
    static $coreHelpersLoaded = 0;
    if ($coreHelpersLoaded)
    {
      return;
    }
    $coreHelpersLoaded = 1;
    $helpers = array_unique(array_merge(array('Helper', 'Url', 'Asset', 'Tag', 'Escaping'), sfConfig::get('sf_standard_helpers')));
    $this->context->getConfiguration()->loadHelpers($helpers);
  }
  protected function renderFile($_sfFile)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Render "%s"', $_sfFile))));
    }
    $this->loadCoreAndStandardHelpers();
        $vars = $this->attributeHolder->toArray();
    extract($vars);
        ob_start();
    ob_implicit_flush(0);
    try
    {
      require($_sfFile);
    }
    catch (Exception $e)
    {
            ob_end_clean();
      throw $e;
    }
    return ob_get_clean();
  }
  public function getEngine()
  {
    return null;
  }
  public function configure()
  {
        $this->context->set('view_instance', $this);
        require($this->context->getConfigCache()->checkConfig('modules/'.$this->moduleName.'/config/view.yml'));
        if (!$this->directory)
    {
      $this->setDirectory($this->context->getConfiguration()->getTemplateDir($this->moduleName, $this->getTemplate()));
    }
  }
  protected function decorate($content)
  {
    if (sfConfig::get('sf_logging_enabled'))
    {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Decorate content with "%s/%s"', $this->getDecoratorDirectory(), $this->getDecoratorTemplate()))));
    }
        $attributeHolder = $this->attributeHolder;
    $this->attributeHolder = $this->initializeAttributeHolder(array('sf_content' => new sfOutputEscaperSafe($content)));
    $this->attributeHolder->set('sf_type', 'layout');
        if (!is_readable($this->getDecoratorDirectory().'/'.$this->getDecoratorTemplate()))
    {
      throw new sfRenderException(sprintf('The decorator template "%s" does not exist or is unreadable in "%s".', $this->decoratorTemplate, $this->decoratorDirectory));
    }
        $ret = $this->renderFile($this->getDecoratorDirectory().'/'.$this->getDecoratorTemplate());
    $this->attributeHolder = $attributeHolder;
    return $ret;
  }
  public function render()
  {
    $content = null;
    if (sfConfig::get('sf_cache'))
    {
      $viewCache = $this->context->getViewCacheManager();
      $uri = $viewCache->getCurrentCacheKey();
      if (null !== $uri)
      {
        list($content, $decoratorTemplate) = $viewCache->getActionCache($uri);
        if (null !== $content)
        {
          $this->setDecoratorTemplate($decoratorTemplate);
        }
      }
    }
        if (null === $content)
    {
            $this->preRenderCheck();
      $this->attributeHolder->set('sf_type', 'action');
            $content = $this->renderFile($this->getDirectory().'/'.$this->getTemplate());
      if (sfConfig::get('sf_cache') && null !== $uri)
      {
        $content = $viewCache->setActionCache($uri, $content, $this->isDecorator() ? $this->getDecoratorDirectory().'/'.$this->getDecoratorTemplate() : false);
      }
    }
        if ($this->isDecorator())
    {
      $content = $this->decorate($content);
    }
    return $content;
  }
}

class sfOutputEscaperSafe extends ArrayIterator
{
  protected
    $value = null;
  public function __construct($value)
  {
    $this->value = $value;
    if (is_array($value) || is_object($value))
    {
      parent::__construct($value);
    }
  }
  public function __toString()
  {
    return (string) $this->value;
  }
  public function __get($key)
  {
    return $this->value->$key;
  }
  public function __set($key, $value)
  {
    $this->value->$key = $value;
  }
  public function __call($method, $arguments)
  {
    return call_user_func_array(array($this->value, $method), $arguments);
  }
  public function __isset($key)
  {
    return isset($this->value->$key);
  }
  public function __unset($key)
  {
    unset($this->value->$key);
  }
  public function getValue()
  {
    return $this->value;
  }
}

