<?php
// Copyright 2004-present Facebook. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

namespace Facebook\WebDriver\Interactions\Internal;

use PHPUnit\Framework\TestCase;

class WebDriverCoordinatesTest extends TestCase
{
    public function testConstruct()
    {
        $in_view_port = function () {
        };
        $on_page = function () {
        };

        $webDriverCoordinates = new WebDriverCoordinates(null, $in_view_port, $on_page, 'auxiliary');

        self::assertAttributeEquals(null, 'onScreen', $webDriverCoordinates);
        self::assertAttributeEquals($in_view_port, 'inViewPort', $webDriverCoordinates);
        self::assertAttributeEquals($on_page, 'onPage', $webDriverCoordinates);
        self::assertAttributeEquals('auxiliary', 'auxiliary', $webDriverCoordinates);
    }

    public function testGetAuxiliary()
    {
        $in_view_port = function () {
        };
        $on_page = function () {
        };

        $webDriverCoordinates = new WebDriverCoordinates(null, $in_view_port, $on_page, 'auxiliary');

        self::assertEquals('auxiliary', $webDriverCoordinates->getAuxiliary());
    }
}
